/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.jdbc;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.calcite.jdbc.CalciteConnectionImpl;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.SimpleCalciteSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LookupCalciteSchema
extends SimpleCalciteSchema {
    private final Function<List<String>, Table> lookup;
    private final Map<List<String>, Table> cache = Maps.newHashMap();

    LookupCalciteSchema(@Nullable CalciteSchema parent, Schema schema, String name, Function<List<String>, Table> lookup) {
        super(parent, schema, name);
        this.lookup = lookup;
    }

    public CalciteSchema add(String name, Schema schema) {
        LookupCalciteSchema calciteSchema = new LookupCalciteSchema((CalciteSchema)this, schema, name, this.lookup);
        this.subSchemaMap.put(name, (Object)calciteSchema);
        return calciteSchema;
    }

    protected @Nullable CalciteSchema getImplicitSubSchema(String schemaName, boolean caseSensitive) {
        if (this.cache.computeIfAbsent(this.path(schemaName), this.lookup) != null) {
            return null;
        }
        this.plus().add(schemaName, AbstractSchema.Factory.INSTANCE.create(null, null, null));
        return super.getSubSchema(schemaName, caseSensitive);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable CalciteSchema.TableEntry getImplicitTable(String tableName, boolean caseSensitive) {
        Table table = this.cache.computeIfAbsent(this.path(tableName), this.lookup);
        if (table == null) {
            return null;
        }
        this.add(tableName, table);
        return this.getTable(tableName, caseSensitive);
    }

    public static CalciteSchema createRootSchema(Function<List<String>, Table> lookup) {
        CalciteConnectionImpl.RootSchema rootSchema = new CalciteConnectionImpl.RootSchema();
        return new LookupCalciteSchema(null, (Schema)rootSchema, "", lookup);
    }
}

