/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import io.substrait.isthmus.RelNodeVisitor;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;

public class OuterReferenceResolver
extends RelNodeVisitor<RelNode, RuntimeException> {
    private Map<CorrelationId, Integer> nestedDepth;
    private Map<RexFieldAccess, Integer> fieldAccessDepthMap;
    private RexVisitor rexVisitor = new RexVisitor(this);

    public OuterReferenceResolver() {
        this.nestedDepth = new HashMap<CorrelationId, Integer>();
        this.fieldAccessDepthMap = new IdentityHashMap<RexFieldAccess, Integer>();
    }

    public int getStepsOut(RexFieldAccess fieldAccess) {
        return this.fieldAccessDepthMap.get(fieldAccess);
    }

    public RelNode apply(RelNode r) {
        return (RelNode)this.reverseAccept(r);
    }

    public Map<RexFieldAccess, Integer> getFieldAccessDepthMap() {
        return this.fieldAccessDepthMap;
    }

    @Override
    public RelNode visit(Filter filter) throws RuntimeException {
        for (CorrelationId id : filter.getVariablesSet()) {
            if (this.nestedDepth.containsKey(id)) continue;
            this.nestedDepth.put(id, 0);
        }
        filter.getCondition().accept((org.apache.calcite.rex.RexVisitor)this.rexVisitor);
        return (RelNode)super.visit(filter);
    }

    @Override
    public RelNode visit(Correlate correlate) throws RuntimeException {
        for (CorrelationId correlationId : correlate.getVariablesSet()) {
            if (this.nestedDepth.containsKey(correlationId)) continue;
            this.nestedDepth.put(correlationId, 0);
        }
        this.apply(correlate.getLeft());
        for (Map.Entry entry : this.nestedDepth.entrySet()) {
            this.nestedDepth.put((CorrelationId)entry.getKey(), (Integer)entry.getValue() + 1);
        }
        this.apply(correlate.getRight());
        for (Map.Entry entry : this.nestedDepth.entrySet()) {
            this.nestedDepth.put((CorrelationId)entry.getKey(), (Integer)entry.getValue() - 1);
        }
        return correlate;
    }

    @Override
    public RelNode visitOther(RelNode other) throws RuntimeException {
        for (RelNode child : other.getInputs()) {
            this.apply(child);
        }
        return other;
    }

    @Override
    public RelNode visit(Project project) throws RuntimeException {
        if (RexUtil.SubQueryFinder.containsSubQuery((Project)project)) {
            throw new UnsupportedOperationException("Unsupported subquery nested in Project relational operator : " + String.valueOf(project));
        }
        return (RelNode)super.visit(project);
    }

    private class RexVisitor
    extends RexShuttle {
        final OuterReferenceResolver referenceResolver;

        RexVisitor(OuterReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public RexNode visitSubQuery(RexSubQuery subQuery) {
            for (Map.Entry<CorrelationId, Integer> entry : this.referenceResolver.nestedDepth.entrySet()) {
                this.referenceResolver.nestedDepth.put(entry.getKey(), entry.getValue() + 1);
            }
            this.referenceResolver.apply(subQuery.rel);
            for (Map.Entry<CorrelationId, Integer> entry : this.referenceResolver.nestedDepth.entrySet()) {
                this.referenceResolver.nestedDepth.put(entry.getKey(), entry.getValue() - 1);
            }
            return subQuery;
        }

        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            CorrelationId id;
            if (fieldAccess.getReferenceExpr() instanceof RexCorrelVariable && this.referenceResolver.nestedDepth.containsKey(id = ((RexCorrelVariable)fieldAccess.getReferenceExpr()).id)) {
                this.referenceResolver.fieldAccessDepthMap.put(fieldAccess, this.referenceResolver.nestedDepth.get(id));
            }
            return fieldAccess;
        }
    }
}

