/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import io.substrait.relation.AbstractDdlRel;
import io.substrait.relation.Aggregate;
import io.substrait.relation.ConsistentPartitionWindow;
import io.substrait.relation.Cross;
import io.substrait.relation.EmptyScan;
import io.substrait.relation.Expand;
import io.substrait.relation.ExtensionDdl;
import io.substrait.relation.ExtensionLeaf;
import io.substrait.relation.ExtensionMulti;
import io.substrait.relation.ExtensionSingle;
import io.substrait.relation.ExtensionTable;
import io.substrait.relation.ExtensionWrite;
import io.substrait.relation.Fetch;
import io.substrait.relation.Filter;
import io.substrait.relation.Join;
import io.substrait.relation.LocalFiles;
import io.substrait.relation.NamedDdl;
import io.substrait.relation.NamedScan;
import io.substrait.relation.NamedUpdate;
import io.substrait.relation.NamedWrite;
import io.substrait.relation.Project;
import io.substrait.relation.RelVisitor;
import io.substrait.relation.Set;
import io.substrait.relation.Sort;
import io.substrait.relation.VirtualTableScan;
import io.substrait.relation.physical.HashJoin;
import io.substrait.relation.physical.MergeJoin;
import io.substrait.relation.physical.NestedLoopJoin;
import io.substrait.util.EmptyVisitationContext;
import org.apache.calcite.sql.SqlKind;

public class SqlKindFromRel
implements RelVisitor<SqlKind, EmptyVisitationContext, RuntimeException> {
    private static final SqlKind QUERY_KIND = SqlKind.SELECT;

    public SqlKind visit(Aggregate aggregate, EmptyVisitationContext context) throws RuntimeException {
        return QUERY_KIND;
    }

    public SqlKind visit(EmptyScan emptyScan, EmptyVisitationContext context) throws RuntimeException {
        return QUERY_KIND;
    }

    public SqlKind visit(Fetch fetch, EmptyVisitationContext context) throws RuntimeException {
        return QUERY_KIND;
    }

    public SqlKind visit(Filter filter, EmptyVisitationContext context) throws RuntimeException {
        return QUERY_KIND;
    }

    public SqlKind visit(Join join, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.JOIN;
    }

    public SqlKind visit(Set set, EmptyVisitationContext context) throws RuntimeException {
        switch (set.getSetOp()) {
            case UNION_ALL: 
            case UNION_DISTINCT: {
                return SqlKind.UNION;
            }
            case INTERSECTION_PRIMARY: 
            case INTERSECTION_MULTISET: 
            case INTERSECTION_MULTISET_ALL: {
                return SqlKind.INTERSECT;
            }
            case MINUS_PRIMARY: 
            case MINUS_PRIMARY_ALL: 
            case MINUS_MULTISET: {
                return SqlKind.EXCEPT;
            }
        }
        return SqlKind.OTHER;
    }

    public SqlKind visit(NamedScan namedScan, EmptyVisitationContext context) throws RuntimeException {
        return QUERY_KIND;
    }

    public SqlKind visit(LocalFiles localFiles, EmptyVisitationContext context) throws RuntimeException {
        return QUERY_KIND;
    }

    public SqlKind visit(Project project, EmptyVisitationContext context) throws RuntimeException {
        return QUERY_KIND;
    }

    public SqlKind visit(Expand expand, EmptyVisitationContext context) throws RuntimeException {
        return QUERY_KIND;
    }

    public SqlKind visit(Sort sort, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.ORDER_BY;
    }

    public SqlKind visit(Cross cross, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.JOIN;
    }

    public SqlKind visit(VirtualTableScan virtualTableScan, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.VALUES;
    }

    public SqlKind visit(ExtensionLeaf extensionLeaf, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.OTHER;
    }

    public SqlKind visit(ExtensionSingle extensionSingle, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.OTHER;
    }

    public SqlKind visit(ExtensionMulti extensionMulti, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.OTHER;
    }

    public SqlKind visit(ExtensionTable extensionTable, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.OTHER;
    }

    public SqlKind visit(HashJoin hashJoin, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.JOIN;
    }

    public SqlKind visit(MergeJoin mergeJoin, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.JOIN;
    }

    public SqlKind visit(NestedLoopJoin nestedLoopJoin, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.JOIN;
    }

    public SqlKind visit(ConsistentPartitionWindow consistentPartitionWindow, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.OVER;
    }

    public SqlKind visit(NamedWrite write, EmptyVisitationContext context) throws RuntimeException {
        switch (write.getOperation()) {
            case INSERT: {
                return SqlKind.INSERT;
            }
            case DELETE: {
                return SqlKind.DELETE;
            }
            case UPDATE: {
                return SqlKind.UPDATE;
            }
            case CTAS: {
                return SqlKind.CREATE_TABLE;
            }
        }
        return SqlKind.OTHER;
    }

    public SqlKind visit(ExtensionWrite write, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.OTHER_DDL;
    }

    public SqlKind visit(NamedDdl ddl, EmptyVisitationContext context) throws RuntimeException {
        switch (ddl.getOperation()) {
            case CREATE: 
            case CREATE_OR_REPLACE: {
                if (ddl.getObject() == AbstractDdlRel.DdlObject.TABLE) {
                    return SqlKind.CREATE_TABLE;
                }
                if (ddl.getObject() != AbstractDdlRel.DdlObject.VIEW) break;
                return SqlKind.CREATE_VIEW;
            }
            case DROP: 
            case DROP_IF_EXIST: {
                if (ddl.getObject() == AbstractDdlRel.DdlObject.TABLE) {
                    return SqlKind.DROP_TABLE;
                }
                if (ddl.getObject() != AbstractDdlRel.DdlObject.VIEW) break;
                return SqlKind.DROP_VIEW;
            }
            case ALTER: {
                if (ddl.getObject() == AbstractDdlRel.DdlObject.TABLE) {
                    return SqlKind.ALTER_TABLE;
                }
                if (ddl.getObject() != AbstractDdlRel.DdlObject.VIEW) break;
                return SqlKind.ALTER_VIEW;
            }
        }
        return SqlKind.OTHER_DDL;
    }

    public SqlKind visit(ExtensionDdl ddl, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.OTHER_DDL;
    }

    public SqlKind visit(NamedUpdate update, EmptyVisitationContext context) throws RuntimeException {
        return SqlKind.UPDATE;
    }
}

