/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import io.substrait.expression.EnumArg;
import io.substrait.extension.SimpleExtension;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.type.SqlTypeName;

public class EnumConverter {
    private static final Map<ArgAnchor, Class<? extends Enum<?>>> calciteEnumMap = new HashMap();

    private static Optional<Enum<?>> constructValue(Class<? extends Enum<?>> cls, Supplier<Optional<String>> option) {
        if (cls.isAssignableFrom(TimeUnitRange.class)) {
            return option.get().map(TimeUnitRange::valueOf);
        }
        if (cls.isAssignableFrom(SqlTrimFunction.Flag.class)) {
            return option.get().map(SqlTrimFunction.Flag::valueOf);
        }
        return Optional.empty();
    }

    static Optional<RexLiteral> toRex(RexBuilder rexBuilder, SimpleExtension.Function fnDef, int argIdx, EnumArg e) {
        ArgAnchor aAnch = EnumConverter.argAnchor(fnDef, argIdx);
        Optional<Class> v = Optional.ofNullable(calciteEnumMap.getOrDefault(aAnch, null));
        Supplier<Optional> sOptionVal = () -> {
            if (e.value().isPresent()) {
                return Optional.of((String)e.value().get());
            }
            return EnumConverter.findEnumArg(fnDef, aAnch).map(ea -> (String)ea.options().get(0));
        };
        return v.flatMap(cls -> EnumConverter.constructValue(cls, sOptionVal)).map(en -> rexBuilder.makeFlag(en));
    }

    private static Optional<SimpleExtension.EnumArgument> findEnumArg(SimpleExtension.Function function, ArgAnchor enumAnchor) {
        if (enumAnchor.fn == function.getAnchor()) {
            return Optional.empty();
        }
        List args = function.args();
        if (args.size() <= enumAnchor.argIdx) {
            return Optional.empty();
        }
        SimpleExtension.Argument arg = (SimpleExtension.Argument)args.get(enumAnchor.argIdx);
        if (arg instanceof SimpleExtension.EnumArgument) {
            return Optional.of((SimpleExtension.EnumArgument)arg);
        }
        return Optional.empty();
    }

    static Optional<EnumArg> fromRex(SimpleExtension.Function function, RexLiteral literal, int argIdx) {
        switch (literal.getType().getSqlTypeName()) {
            case SYMBOL: {
                Comparable v = literal.getValue();
                if (!literal.isNull() && v instanceof Enum) {
                    Enum value = (Enum)((Object)v);
                    ArgAnchor enumAnchor = EnumConverter.argAnchor(function, argIdx);
                    return EnumConverter.findEnumArg(function, enumAnchor).map(ea -> EnumArg.of((SimpleExtension.EnumArgument)ea, (String)value.name()));
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    static boolean canConvert(Enum<?> value) {
        return value != null && calciteEnumMap.containsValue(value.getClass());
    }

    static boolean isEnumValue(RexNode value) {
        return value instanceof RexLiteral && value.getType().getSqlTypeName() == SqlTypeName.SYMBOL;
    }

    private static ArgAnchor argAnchor(String fnNS, String fnSig, int argIdx) {
        return new ArgAnchor(SimpleExtension.FunctionAnchor.of((String)fnNS, (String)fnSig), argIdx);
    }

    private static ArgAnchor argAnchor(SimpleExtension.Function fnDef, int argIdx) {
        return new ArgAnchor(SimpleExtension.FunctionAnchor.of((String)fnDef.getAnchor().namespace(), (String)fnDef.getAnchor().key()), argIdx);
    }

    static {
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_datetime.yaml", "extract:req_ts", 0), TimeUnitRange.class);
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_datetime.yaml", "extract:req_tstz_str", 0), TimeUnitRange.class);
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_datetime.yaml", "extract:req_pts", 0), TimeUnitRange.class);
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_datetime.yaml", "extract:req_ptstz_str", 0), TimeUnitRange.class);
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_datetime.yaml", "extract:req_date", 0), TimeUnitRange.class);
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_datetime.yaml", "extract:req_time", 0), TimeUnitRange.class);
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_string.yaml", "trim:vchar_vchar", 0), SqlTrimFunction.Flag.class);
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_string.yaml", "trim:str_str", 0), SqlTrimFunction.Flag.class);
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_string.yaml", "ltrim:vchar_vchar", 0), SqlTrimFunction.Flag.class);
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_string.yaml", "ltrim:str_str", 0), SqlTrimFunction.Flag.class);
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_string.yaml", "rtrim:vchar_vchar", 0), SqlTrimFunction.Flag.class);
        calciteEnumMap.put(EnumConverter.argAnchor("/functions_string.yaml", "rtrim:str_str", 0), SqlTrimFunction.Flag.class);
    }

    private static class ArgAnchor {
        public final SimpleExtension.FunctionAnchor fn;
        public final int argIdx;

        public ArgAnchor(SimpleExtension.FunctionAnchor fn, int argIdx) {
            this.fn = fn;
            this.argIdx = argIdx;
        }

        public int hashCode() {
            return Objects.hash(this.fn, this.argIdx);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ArgAnchor)) {
                return false;
            }
            ArgAnchor other = (ArgAnchor)obj;
            return Objects.equals(this.fn, other.fn) && this.argIdx == other.argIdx;
        }
    }
}

