/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import io.substrait.expression.AbstractExpressionVisitor;
import io.substrait.expression.EnumArg;
import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionVisitor;
import io.substrait.expression.FieldReference;
import io.substrait.expression.FunctionArg;
import io.substrait.expression.WindowBound;
import io.substrait.extension.SimpleExtension;
import io.substrait.function.TypeExpression;
import io.substrait.isthmus.SubstraitRelNodeConverter;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.expression.EnumConverter;
import io.substrait.isthmus.expression.ScalarFunctionConverter;
import io.substrait.isthmus.expression.WindowFunctionConverter;
import io.substrait.relation.RelVisitor;
import io.substrait.type.StringTypeVisitor;
import io.substrait.type.Type;
import io.substrait.type.TypeVisitor;
import io.substrait.util.DecimalUtil;
import io.substrait.util.VisitationContext;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;

public class ExpressionRexConverter
extends AbstractExpressionVisitor<RexNode, SubstraitRelNodeConverter.Context, RuntimeException>
implements FunctionArg.FuncArgVisitor<RexNode, SubstraitRelNodeConverter.Context, RuntimeException> {
    private static final SqlIntervalQualifier YEAR_MONTH_INTERVAL = new SqlIntervalQualifier(TimeUnit.YEAR, -1, TimeUnit.MONTH, -1, SqlParserPos.QUOTED_ZERO);
    private static final SqlIntervalQualifier DAY_SECOND_INTERVAL = new SqlIntervalQualifier(TimeUnit.DAY, -1, TimeUnit.SECOND, 3, SqlParserPos.QUOTED_ZERO);
    private static final long MILLIS_IN_DAY = java.util.concurrent.TimeUnit.DAYS.toMillis(1L);
    protected final RelDataTypeFactory typeFactory;
    protected final TypeConverter typeConverter;
    protected final RexBuilder rexBuilder;
    protected final ScalarFunctionConverter scalarFunctionConverter;
    protected final WindowFunctionConverter windowFunctionConverter;
    protected SubstraitRelNodeConverter relNodeConverter;

    public ExpressionRexConverter(RelDataTypeFactory typeFactory, ScalarFunctionConverter scalarFunctionConverter, WindowFunctionConverter windowFunctionConverter, TypeConverter typeConverter) {
        this.typeFactory = typeFactory;
        this.typeConverter = typeConverter;
        this.rexBuilder = new RexBuilder(typeFactory);
        this.scalarFunctionConverter = scalarFunctionConverter;
        this.windowFunctionConverter = windowFunctionConverter;
    }

    public void setRelNodeConverter(SubstraitRelNodeConverter substraitRelNodeConverter) {
        this.relNodeConverter = substraitRelNodeConverter;
    }

    public RexNode visit(Expression.NullLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral(null, this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.UserDefinedLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        RexLiteral binaryLiteral = this.rexBuilder.makeBinaryLiteral(new ByteString(expr.value().toByteArray()));
        RelDataType type = this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType());
        return this.rexBuilder.makeReinterpretCast(type, (RexNode)binaryLiteral, (RexNode)this.rexBuilder.makeLiteral(false));
    }

    public RexNode visit(Expression.BoolLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral(expr.value().booleanValue());
    }

    public RexNode visit(Expression.I8Literal expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.I16Literal expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.I32Literal expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.I64Literal expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.FP32Literal expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)Float.valueOf(expr.value()), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.FP64Literal expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.FixedCharLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral(expr.value());
    }

    public RexNode visit(Expression.StrLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()), true);
    }

    public RexNode visit(Expression.VarCharLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()), true);
    }

    public RexNode visit(Expression.FixedBinaryLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)new ByteString(expr.value().toByteArray()), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()), true);
    }

    public RexNode visit(Expression.BinaryLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)new ByteString(expr.value().toByteArray()), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()), true);
    }

    public RexNode visit(Expression.TimeLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        long microSec = expr.value();
        long seconds = java.util.concurrent.TimeUnit.MICROSECONDS.toSeconds(microSec);
        int fracSecondsInNano = (int)(java.util.concurrent.TimeUnit.MICROSECONDS.toNanos(microSec) - java.util.concurrent.TimeUnit.SECONDS.toNanos(seconds));
        TimeString timeString = TimeString.fromMillisOfDay((int)((int)java.util.concurrent.TimeUnit.SECONDS.toMillis(seconds))).withNanos(fracSecondsInNano);
        return this.rexBuilder.makeLiteral((Object)timeString, this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.SingleOrList expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        RexNode lhs = (RexNode)expr.condition().accept((ExpressionVisitor)this, (VisitationContext)context);
        return this.rexBuilder.makeIn(lhs, expr.options().stream().map(e -> (RexNode)e.accept((ExpressionVisitor)this, (VisitationContext)context)).collect(Collectors.toList()));
    }

    public RexNode visit(Expression.DateLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)expr.value(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.TimestampLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)this.getTimestampString(expr.value()), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.TimestampTZLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)this.getTimestampString(expr.value()), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.PrecisionTimestampLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)this.getTimestampString(expr.value(), expr.precision()), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.PrecisionTimestampTZLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeLiteral((Object)this.getTimestampString(expr.value(), expr.precision()), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    private TimestampString getTimestampString(long microSec) {
        return this.getTimestampString(microSec, 6);
    }

    private TimestampString getTimestampString(long value, int precision) {
        switch (precision) {
            case 0: {
                return TimestampString.fromMillisSinceEpoch((long)java.util.concurrent.TimeUnit.SECONDS.toMillis(value));
            }
            case 3: {
                long seconds = java.util.concurrent.TimeUnit.MILLISECONDS.toSeconds(value);
                int fracSecondsInNano = (int)(java.util.concurrent.TimeUnit.MILLISECONDS.toNanos(value) - java.util.concurrent.TimeUnit.SECONDS.toNanos(seconds));
                return TimestampString.fromMillisSinceEpoch((long)java.util.concurrent.TimeUnit.SECONDS.toMillis(seconds)).withNanos(fracSecondsInNano);
            }
            case 6: {
                long seconds = java.util.concurrent.TimeUnit.MICROSECONDS.toSeconds(value);
                int fracSecondsInNano = (int)(java.util.concurrent.TimeUnit.MICROSECONDS.toNanos(value) - java.util.concurrent.TimeUnit.SECONDS.toNanos(seconds));
                return TimestampString.fromMillisSinceEpoch((long)java.util.concurrent.TimeUnit.SECONDS.toMillis(seconds)).withNanos(fracSecondsInNano);
            }
            case 9: {
                long seconds = java.util.concurrent.TimeUnit.NANOSECONDS.toSeconds(value);
                int fracSecondsInNano = (int)(value - java.util.concurrent.TimeUnit.SECONDS.toNanos(seconds));
                return TimestampString.fromMillisSinceEpoch((long)java.util.concurrent.TimeUnit.SECONDS.toMillis(seconds)).withNanos(fracSecondsInNano);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot handle PrecisionTimestamp with precision %d.", precision));
    }

    public RexNode visit(Expression.IntervalYearLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return this.rexBuilder.makeIntervalLiteral(new BigDecimal(expr.years() * 12 + expr.months()), YEAR_MONTH_INTERVAL);
    }

    public RexNode visit(Expression.IntervalDayLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        long milliseconds = expr.precision() > 3 ? expr.subseconds() / (long)((int)Math.pow(10.0, expr.precision() - 3)) : expr.subseconds() * (long)((int)Math.pow(10.0, 3 - expr.precision()));
        return this.rexBuilder.makeIntervalLiteral(new BigDecimal((long)expr.days() * MILLIS_IN_DAY + (long)expr.seconds() * 1000L + milliseconds), DAY_SECOND_INTERVAL);
    }

    public RexNode visit(Expression.DecimalLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        byte[] value = expr.value().toByteArray();
        BigDecimal decimal = DecimalUtil.getBigDecimalFromBytes((byte[])value, (int)expr.scale(), (int)16);
        return this.rexBuilder.makeLiteral((Object)decimal, this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
    }

    public RexNode visit(Expression.ListLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        List args = expr.values().stream().map(l -> (RexNode)l.accept((ExpressionVisitor)this, (VisitationContext)context)).collect(Collectors.toList());
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, args);
    }

    public RexNode visit(Expression.EmptyListLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        RelDataType calciteType = this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType());
        return this.rexBuilder.makeCall(calciteType, (SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, Collections.emptyList());
    }

    public RexNode visit(Expression.MapLiteral expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        List args = expr.values().entrySet().stream().flatMap(entry -> Stream.of((RexNode)((Expression.Literal)entry.getKey()).accept((ExpressionVisitor)this, (VisitationContext)context), (RexNode)((Expression.Literal)entry.getValue()).accept((ExpressionVisitor)this, (VisitationContext)context))).collect(Collectors.toList());
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, args);
    }

    public RexNode visit(Expression.IfThen expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        Stream ifThenArgs = expr.ifClauses().stream().flatMap(clause -> Stream.of((RexNode)clause.condition().accept((ExpressionVisitor)this, (VisitationContext)context), (RexNode)clause.then().accept((ExpressionVisitor)this, (VisitationContext)context)));
        Stream<RexNode> elseArg = Stream.of((RexNode)expr.elseClause().accept((ExpressionVisitor)this, (VisitationContext)context));
        List args = Stream.concat(ifThenArgs, elseArg).collect(Collectors.toList());
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, args);
    }

    public RexNode visit(Expression.Switch expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        RexNode match = (RexNode)expr.match().accept((ExpressionVisitor)this, (VisitationContext)context);
        Stream caseThenArgs = expr.switchClauses().stream().flatMap(clause -> Stream.of(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{match, (RexNode)clause.condition().accept((ExpressionVisitor)this, (VisitationContext)context)}), (RexNode)clause.then().accept((ExpressionVisitor)this, (VisitationContext)context)));
        Stream<RexNode> defaultArg = Stream.of((RexNode)expr.defaultClause().accept((ExpressionVisitor)this, (VisitationContext)context));
        List args = Stream.concat(caseThenArgs, defaultArg).collect(Collectors.toList());
        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, args);
    }

    public RexNode visit(Expression.ScalarFunctionInvocation expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        SqlOperator operator = this.scalarFunctionConverter.getSqlOperatorFromSubstraitFunc(expr.declaration().key(), expr.outputType()).orElseThrow(() -> new IllegalArgumentException(this.callConversionFailureMessage("scalar", expr.declaration().name(), expr.arguments())));
        List<FunctionArg> eArgs = this.scalarFunctionConverter.getExpressionArguments(expr);
        List args = IntStream.range(0, eArgs.size()).mapToObj(i -> (RexNode)((FunctionArg)eArgs.get(i)).accept((SimpleExtension.Function)expr.declaration(), i, (FunctionArg.FuncArgVisitor)this, (VisitationContext)context)).collect(Collectors.toList());
        RelDataType returnType = this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.outputType());
        return this.rexBuilder.makeCall(returnType, operator, args);
    }

    private String callConversionFailureMessage(String functionType, String name, List<FunctionArg> args) {
        return String.format("Unable to convert %s function %s(%s).", functionType, name, args.stream().map(this::convert).collect(Collectors.joining(", ")));
    }

    public RexNode visit(Expression.WindowFunctionInvocation expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        SqlOperator operator = this.windowFunctionConverter.getSqlOperatorFromSubstraitFunc(expr.declaration().key(), expr.outputType()).orElseThrow(() -> new IllegalArgumentException(this.callConversionFailureMessage("window", expr.declaration().name(), expr.arguments())));
        RelDataType outputType = this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.outputType());
        List eArgs = expr.arguments();
        List args = IntStream.range(0, eArgs.size()).mapToObj(i -> (RexNode)((FunctionArg)eArgs.get(i)).accept((SimpleExtension.Function)expr.declaration(), i, (FunctionArg.FuncArgVisitor)this, (VisitationContext)context)).collect(Collectors.toList());
        List partitionKeys = expr.partitionBy().stream().map(e -> (RexNode)e.accept((ExpressionVisitor)this, (VisitationContext)context)).collect(Collectors.toList());
        ImmutableList orderKeys = (ImmutableList)expr.sort().stream().map(sf -> {
            Set<SqlKind> direction = this.asSqlKind(sf.direction());
            return new RexFieldCollation((RexNode)sf.expr().accept((ExpressionVisitor)this, (VisitationContext)context), direction);
        }).collect(ImmutableList.toImmutableList());
        RexWindowBound lowerBound = ToRexWindowBound.lowerBound(this.rexBuilder, expr.lowerBound());
        RexWindowBound upperBound = ToRexWindowBound.upperBound(this.rexBuilder, expr.upperBound());
        boolean rowMode = this.isRowMode(expr);
        boolean distinct = this.isDistinct(expr);
        boolean ignoreNulls = false;
        boolean nullWhenCountZero = false;
        boolean allowPartial = true;
        return this.rexBuilder.makeOver(outputType, (SqlAggFunction)operator, args, partitionKeys, orderKeys, lowerBound, upperBound, rowMode, allowPartial, nullWhenCountZero, distinct, ignoreNulls);
    }

    private Set<SqlKind> asSqlKind(Expression.SortDirection direction) {
        switch (direction) {
            case ASC_NULLS_FIRST: {
                return Set.of(SqlKind.NULLS_FIRST);
            }
            case ASC_NULLS_LAST: {
                return Set.of(SqlKind.NULLS_LAST);
            }
            case DESC_NULLS_FIRST: {
                return Set.of(SqlKind.DESCENDING, SqlKind.NULLS_FIRST);
            }
            case DESC_NULLS_LAST: {
                return Set.of(SqlKind.DESCENDING, SqlKind.NULLS_LAST);
            }
            case CLUSTERED: {
                throw new IllegalArgumentException("SORT_DIRECTION_CLUSTERED is not supported");
            }
        }
        throw new IllegalArgumentException("Unsupported sort direction: " + String.valueOf(direction));
    }

    private boolean isRowMode(Expression.WindowFunctionInvocation expr) {
        Expression.WindowBoundsType boundsType = expr.boundsType();
        switch (boundsType) {
            case ROWS: {
                return true;
            }
            case RANGE: {
                return false;
            }
            case UNSPECIFIED: {
                throw new IllegalArgumentException("bounds type on window function must be specified");
            }
        }
        throw new IllegalArgumentException("Unsupported window function bounds type: " + String.valueOf(boundsType));
    }

    private boolean isDistinct(Expression.WindowFunctionInvocation expr) {
        Expression.AggregationInvocation invocation = expr.invocation();
        switch (invocation) {
            case UNSPECIFIED: 
            case ALL: {
                return false;
            }
            case DISTINCT: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unsupported window function invocation: " + String.valueOf(invocation));
    }

    public RexNode visit(Expression.InPredicate expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        List needles = expr.needles().stream().map(e -> (RexNode)e.accept((ExpressionVisitor)this, (VisitationContext)context)).collect(Collectors.toList());
        context.incrementSubqueryDepth();
        RelNode rel = (RelNode)expr.haystack().accept((RelVisitor)this.relNodeConverter, (VisitationContext)context);
        context.decrementSubqueryDepth();
        return RexSubQuery.in((RelNode)rel, (ImmutableList)ImmutableList.copyOf(needles));
    }

    private String convert(FunctionArg a) {
        String v;
        if (a instanceof EnumArg) {
            v = ((EnumArg)a).value().toString();
        } else if (a instanceof Expression) {
            v = (String)((Expression)a).getType().accept((TypeVisitor)new StringTypeVisitor());
        } else if (a instanceof Type) {
            v = (String)((Type)a).accept((TypeVisitor)new StringTypeVisitor());
        } else {
            throw new IllegalStateException("Unexpected value: " + String.valueOf(a));
        }
        return v;
    }

    public RexNode visit(Expression.Cast expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        boolean safeCast = expr.failureBehavior() == Expression.FailureBehavior.RETURN_NULL;
        return this.rexBuilder.makeAbstractCast(this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()), (RexNode)expr.input().accept((ExpressionVisitor)this, (VisitationContext)context), safeCast);
    }

    public RexNode visit(FieldReference expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        if (expr.isSimpleRootReference()) {
            FieldReference.ReferenceSegment segment = (FieldReference.ReferenceSegment)expr.segments().get(0);
            if (!(segment instanceof FieldReference.StructField)) {
                throw new IllegalArgumentException("Unhandled type: " + String.valueOf(segment));
            }
            FieldReference.StructField field = (FieldReference.StructField)segment;
            RexInputRef rexInputRef = new RexInputRef(field.offset(), this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)expr.getType()));
            return rexInputRef;
        }
        if (expr.isOuterReference()) {
            FieldReference.ReferenceSegment segment = (FieldReference.ReferenceSegment)expr.segments().get(0);
            if (!(segment instanceof FieldReference.StructField)) {
                throw new IllegalArgumentException("Unhandled type: " + String.valueOf(segment));
            }
            FieldReference.StructField field = (FieldReference.StructField)segment;
            RangeMap<Integer, RelDataType> fieldRangeMap = context.getOuterRowTypeRangeMap((Integer)expr.outerReferenceStepsOut().get());
            Range range = (Range)fieldRangeMap.getEntry((Comparable)Integer.valueOf(field.offset())).getKey();
            int fieldOffset = field.offset() - (Integer)range.lowerEndpoint();
            CorrelationId correlationId = this.relNodeConverter.getRelBuilder().getCluster().createCorrel();
            context.addCorrelationId((Integer)expr.outerReferenceStepsOut().get(), correlationId);
            RexNode rexInputRef = this.rexBuilder.makeFieldAccess(this.rexBuilder.makeCorrel((RelDataType)fieldRangeMap.get((Comparable)Integer.valueOf(field.offset())), correlationId), fieldOffset);
            return rexInputRef;
        }
        return this.visitFallback((Expression)expr, context);
    }

    public RexNode visitFallback(Expression expr, SubstraitRelNodeConverter.Context context) {
        throw new UnsupportedOperationException(String.format("Expression %s of type %s not handled by visitor type %s.", expr, expr.getClass().getCanonicalName(), ((Object)((Object)this)).getClass().getCanonicalName()));
    }

    public RexNode visitExpr(SimpleExtension.Function fnDef, int argIdx, Expression e, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return (RexNode)e.accept((ExpressionVisitor)this, (VisitationContext)context);
    }

    public RexNode visitType(SimpleExtension.Function fnDef, int argIdx, Type t, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        throw new UnsupportedOperationException(String.format("FunctionArg %s not handled by visitor type %s.", t, ((Object)((Object)this)).getClass().getCanonicalName()));
    }

    public RexNode visitEnumArg(SimpleExtension.Function fnDef, int argIdx, EnumArg e, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        return (RexNode)EnumConverter.toRex(this.rexBuilder, fnDef, argIdx, e).orElseThrow(() -> new UnsupportedOperationException(String.format("EnumArg(value=%s) not handled by visitor type %s.", e.value(), ((Object)((Object)this)).getClass().getCanonicalName())));
    }

    public RexNode visit(Expression.ScalarSubquery expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        context.incrementSubqueryDepth();
        RelNode inputRelnode = (RelNode)expr.input().accept((RelVisitor)this.relNodeConverter, (VisitationContext)context);
        context.decrementSubqueryDepth();
        return RexSubQuery.scalar((RelNode)inputRelnode);
    }

    public RexNode visit(Expression.SetPredicate expr, SubstraitRelNodeConverter.Context context) throws RuntimeException {
        context.incrementSubqueryDepth();
        RelNode inputRelnode = (RelNode)expr.tuples().accept((RelVisitor)this.relNodeConverter, (VisitationContext)context);
        context.decrementSubqueryDepth();
        switch (expr.predicateOp()) {
            case PREDICATE_OP_EXISTS: {
                return RexSubQuery.exists((RelNode)inputRelnode);
            }
            case PREDICATE_OP_UNIQUE: {
                return RexSubQuery.unique((RelNode)inputRelnode);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot handle SetPredicate when PredicateOp is %s.", expr.predicateOp().name()));
    }

    static class ToRexWindowBound
    implements WindowBound.WindowBoundVisitor<RexWindowBound, RuntimeException> {
        private final RexBuilder rexBuilder;
        private final RexWindowBound unboundedVariant;

        static RexWindowBound lowerBound(RexBuilder rexBuilder, WindowBound bound) {
            return (RexWindowBound)bound.accept((WindowBound.WindowBoundVisitor)new ToRexWindowBound(rexBuilder, RexWindowBounds.UNBOUNDED_PRECEDING));
        }

        static RexWindowBound upperBound(RexBuilder rexBuilder, WindowBound bound) {
            return (RexWindowBound)bound.accept((WindowBound.WindowBoundVisitor)new ToRexWindowBound(rexBuilder, RexWindowBounds.UNBOUNDED_FOLLOWING));
        }

        private ToRexWindowBound(RexBuilder rexBuilder, RexWindowBound unboundedVariant) {
            this.rexBuilder = rexBuilder;
            this.unboundedVariant = unboundedVariant;
        }

        public RexWindowBound visit(WindowBound.Preceding preceding) {
            BigDecimal offset = BigDecimal.valueOf(preceding.offset());
            return RexWindowBounds.preceding((RexNode)this.rexBuilder.makeBigintLiteral(offset));
        }

        public RexWindowBound visit(WindowBound.Following following) {
            BigDecimal offset = BigDecimal.valueOf(following.offset());
            return RexWindowBounds.following((RexNode)this.rexBuilder.makeBigintLiteral(offset));
        }

        public RexWindowBound visit(WindowBound.CurrentRow currentRow) {
            return RexWindowBounds.CURRENT_ROW;
        }

        public RexWindowBound visit(WindowBound.Unbounded unbounded) {
            return this.unboundedVariant;
        }
    }
}

