/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionCreator;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.expression.EnumConverter;
import io.substrait.type.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;

public class LiteralConverter {
    static final DateTimeFormatter CALCITE_LOCAL_DATE_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    static final DateTimeFormatter CALCITE_LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private static final DateTimeFormatter CALCITE_LOCAL_DATETIME_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().append(CALCITE_LOCAL_DATE_FORMATTER).appendLiteral(' ').append(CALCITE_LOCAL_TIME_FORMATTER).toFormatter();
    private final TypeConverter typeConverter;

    public LiteralConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    private static BigDecimal i(RexLiteral literal) {
        return LiteralConverter.bd(literal).setScale(0, RoundingMode.HALF_UP);
    }

    private static String s(RexLiteral literal) {
        return ((NlsString)literal.getValue()).getValue();
    }

    private static BigDecimal bd(RexLiteral literal) {
        return (BigDecimal)literal.getValue();
    }

    public Expression.Literal convert(RexLiteral literal) {
        Type type = this.typeConverter.toSubstrait(literal.getType());
        boolean n = type.nullable();
        if (literal.isNull()) {
            return ExpressionCreator.typedNull((Type)type);
        }
        switch (literal.getType().getSqlTypeName()) {
            case TINYINT: {
                return ExpressionCreator.i8((boolean)n, (int)LiteralConverter.i(literal).intValue());
            }
            case SMALLINT: {
                return ExpressionCreator.i16((boolean)n, (int)LiteralConverter.i(literal).intValue());
            }
            case INTEGER: {
                return ExpressionCreator.i32((boolean)n, (int)LiteralConverter.i(literal).intValue());
            }
            case BIGINT: {
                return ExpressionCreator.i64((boolean)n, (long)LiteralConverter.i(literal).longValue());
            }
            case BOOLEAN: {
                return ExpressionCreator.bool((boolean)n, (boolean)((Boolean)literal.getValueAs(Boolean.class)));
            }
            case CHAR: {
                Comparable val = literal.getValue();
                if (val instanceof NlsString) {
                    NlsString nls = (NlsString)val;
                    return ExpressionCreator.fixedChar((boolean)n, (String)nls.getValue());
                }
                throw new UnsupportedOperationException("Unable to handle char type: " + String.valueOf(val));
            }
            case FLOAT: 
            case DOUBLE: {
                return ExpressionCreator.fp64((boolean)n, (double)((Double)literal.getValueAs(Double.class)));
            }
            case REAL: {
                return ExpressionCreator.fp32((boolean)n, (float)((Float)literal.getValueAs(Float.class)).floatValue());
            }
            case DECIMAL: {
                BigDecimal bd = LiteralConverter.bd(literal);
                return ExpressionCreator.decimal((boolean)n, (BigDecimal)bd, (int)literal.getType().getPrecision(), (int)literal.getType().getScale());
            }
            case VARCHAR: {
                if (literal.getType().getPrecision() == -1) {
                    return ExpressionCreator.string((boolean)n, (String)LiteralConverter.s(literal));
                }
                return ExpressionCreator.varChar((boolean)n, (String)LiteralConverter.s(literal), (int)literal.getType().getPrecision());
            }
            case BINARY: {
                return ExpressionCreator.fixedBinary((boolean)n, (com.google.protobuf.ByteString)com.google.protobuf.ByteString.copyFrom((byte[])LiteralConverter.padRightIfNeeded((ByteString)literal.getValueAs(ByteString.class), literal.getType().getPrecision())));
            }
            case VARBINARY: {
                return ExpressionCreator.binary((boolean)n, (com.google.protobuf.ByteString)com.google.protobuf.ByteString.copyFrom((byte[])((byte[])literal.getValueAs(byte[].class))));
            }
            case SYMBOL: {
                Comparable value = literal.getValue();
                if (value instanceof NlsString) {
                    return ExpressionCreator.string((boolean)n, (String)((NlsString)value).getValue());
                }
                if (value instanceof Enum) {
                    Enum v = (Enum)((Object)value);
                    Optional r = EnumConverter.canConvert(v) ? Optional.of(ExpressionCreator.string((boolean)n, (String)v.name())) : Optional.empty();
                    return (Expression.Literal)r.orElseThrow(() -> new UnsupportedOperationException("Unable to handle symbol: " + String.valueOf(value)));
                }
                throw new UnsupportedOperationException("Unable to handle symbol: " + String.valueOf(value));
            }
            case DATE: {
                DateString date = (DateString)literal.getValueAs(DateString.class);
                LocalDate localDate = LocalDate.parse(date.toString(), CALCITE_LOCAL_DATE_FORMATTER);
                return ExpressionCreator.date((boolean)n, (int)((int)localDate.toEpochDay()));
            }
            case TIME: {
                TimeString time = (TimeString)literal.getValueAs(TimeString.class);
                LocalTime localTime = LocalTime.parse(time.toString(), CALCITE_LOCAL_TIME_FORMATTER);
                return ExpressionCreator.time((boolean)n, (long)TimeUnit.NANOSECONDS.toMicros(localTime.toNanoOfDay()));
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                TimestampString timestamp = (TimestampString)literal.getValueAs(TimestampString.class);
                LocalDateTime ldt = LocalDateTime.parse(timestamp.toString(), CALCITE_LOCAL_DATETIME_FORMATTER);
                return ExpressionCreator.timestamp((boolean)n, (LocalDateTime)ldt);
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                long intervalLength = Objects.requireNonNull((Long)literal.getValueAs(Long.class));
                long years = intervalLength / 12L;
                long months = intervalLength - years * 12L;
                return ExpressionCreator.intervalYear((boolean)n, (int)((int)years), (int)((int)months));
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                Long totalMillis = Objects.requireNonNull((Long)literal.getValueAs(Long.class));
                Duration interval = Duration.ofMillis(totalMillis);
                long days = interval.toDays();
                long seconds = interval.minusDays(days).toSeconds();
                int micros = interval.toMillisPart() * 1000;
                return ExpressionCreator.intervalDay((boolean)n, (int)((int)days), (int)((int)seconds), (long)micros, (int)6);
            }
            case ROW: {
                List literals = (List)((Object)literal.getValue());
                return ExpressionCreator.struct((boolean)n, (Iterable)literals.stream().map(this::convert).collect(Collectors.toList()));
            }
            case ARRAY: {
                List literals = (List)((Object)literal.getValue());
                return ExpressionCreator.list((boolean)n, (Iterable)literals.stream().map(this::convert).collect(Collectors.toList()));
            }
        }
        throw new UnsupportedOperationException(String.format("Unable to convert the value of %s of type %s to a literal.", literal, literal.getType().getSqlTypeName()));
    }

    public static byte[] padRightIfNeeded(ByteString bytes, int length) {
        return LiteralConverter.padRightIfNeeded(bytes.getBytes(), length);
    }

    public static byte[] padRightIfNeeded(byte[] value, int length) {
        if (length < value.length) {
            throw new IllegalArgumentException("Byte values should either be at or below the expected length.");
        }
        if (length == value.length) {
            return value;
        }
        byte[] newArray = new byte[length];
        System.arraycopy(value, 0, newArray, 0, value.length);
        return newArray;
    }
}

