/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.sql;

import io.substrait.isthmus.SubstraitTypeSystem;
import io.substrait.isthmus.calcite.SubstraitTable;
import io.substrait.isthmus.sql.SubstraitSqlValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlCreateTable;
import org.apache.calcite.sql.ddl.SqlKeyConstraint;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.ddl.SqlDdlParserImpl;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidator;

public class SubstraitCreateStatementParser {
    private static final RelDataTypeFactory TYPE_FACTORY = new JavaTypeFactoryImpl(SubstraitTypeSystem.TYPE_SYSTEM);
    private static final CalciteConnectionConfig CONNECTION_CONFIG = CalciteConnectionConfig.DEFAULT.set(CalciteConnectionProperty.CASE_SENSITIVE, Boolean.FALSE.toString());
    private static final SqlParser.Config PARSER_CONFIG = SqlParser.config().withParserFactory(SqlDdlParserImpl.FACTORY).withUnquotedCasing(Casing.TO_UPPER).withConformance((SqlConformance)SqlConformanceEnum.LENIENT);
    private static final CalciteCatalogReader EMPTY_CATALOG = new CalciteCatalogReader(CalciteSchema.createRootSchema((boolean)false), List.of(), TYPE_FACTORY, CONNECTION_CONFIG);
    private static final SqlValidator VALIDATOR = new SubstraitSqlValidator((Prepare.CatalogReader)EMPTY_CATALOG);

    public static List<SubstraitTable> processCreateStatements(String createStatements) throws SqlParseException {
        SqlParser parser = SqlParser.create((String)createStatements, (SqlParser.Config)PARSER_CONFIG);
        ArrayList<SubstraitTable> tableList = new ArrayList<SubstraitTable>();
        SqlNodeList sqlNode = parser.parseStmtList();
        for (SqlNode parsed : sqlNode) {
            if (!(parsed instanceof SqlCreateTable)) {
                throw SubstraitCreateStatementParser.fail("Not a valid CREATE TABLE statement.");
            }
            SqlCreateTable create = (SqlCreateTable)parsed;
            if (create.name.names.size() > 1) {
                throw SubstraitCreateStatementParser.fail("Only simple table names are allowed.", create.name.getParserPosition());
            }
            if (create.query != null) {
                throw SubstraitCreateStatementParser.fail("CTAS not supported.", create.name.getParserPosition());
            }
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<RelDataType> columnTypes = new ArrayList<RelDataType>();
            for (SqlNode node : create.columnList) {
                if (!(node instanceof SqlColumnDeclaration)) {
                    if (node instanceof SqlKeyConstraint) continue;
                    throw SubstraitCreateStatementParser.fail("Unexpected column list construction.", node.getParserPosition());
                }
                SqlColumnDeclaration col = (SqlColumnDeclaration)node;
                if (col.name.names.size() != 1) {
                    throw SubstraitCreateStatementParser.fail("Expected simple column names.", col.name.getParserPosition());
                }
                names.add((String)col.name.names.get(0));
                columnTypes.add(col.dataType.deriveType(VALIDATOR));
            }
            tableList.add(new SubstraitTable((String)create.name.names.get(0), TYPE_FACTORY.createStructType(columnTypes, names)));
        }
        return tableList;
    }

    public static CalciteCatalogReader processCreateStatementsToCatalog(String ... createStatements) throws SqlParseException {
        ArrayList<SubstraitTable> tables = new ArrayList<SubstraitTable>();
        for (String statement : createStatements) {
            tables.addAll(SubstraitCreateStatementParser.processCreateStatements(statement));
        }
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)false);
        for (SubstraitTable table : tables) {
            rootSchema.add(table.getName(), (Table)table);
        }
        List defaultSchema = Collections.emptyList();
        return new CalciteCatalogReader(rootSchema, defaultSchema, TYPE_FACTORY, CONNECTION_CONFIG);
    }

    private static SqlParseException fail(String text, SqlParserPos pos) {
        return new SqlParseException(text, pos, null, null, (Throwable)new RuntimeException("fake lineage"));
    }

    private static SqlParseException fail(String text) {
        return SubstraitCreateStatementParser.fail(text, SqlParserPos.ZERO);
    }
}

