/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import io.substrait.isthmus.RelNodeVisitor;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;

public class OuterReferenceResolver
extends RelNodeVisitor<RelNode, RuntimeException> {
    private final Map<CorrelationId, Integer> nestedDepth;
    private final Map<RexFieldAccess, Integer> fieldAccessDepthMap;
    private final RexVisitor rexVisitor = new RexVisitor(this);

    public OuterReferenceResolver() {
        this.nestedDepth = new HashMap<CorrelationId, Integer>();
        this.fieldAccessDepthMap = new IdentityHashMap<RexFieldAccess, Integer>();
    }

    public int getStepsOut(RexFieldAccess fieldAccess) {
        return this.fieldAccessDepthMap.get(fieldAccess);
    }

    public RelNode apply(RelNode r) {
        return (RelNode)this.reverseAccept(r);
    }

    public Map<RexFieldAccess, Integer> getFieldAccessDepthMap() {
        return this.fieldAccessDepthMap;
    }

    @Override
    public RelNode visit(Filter filter) throws RuntimeException {
        for (CorrelationId id : filter.getVariablesSet()) {
            this.nestedDepth.putIfAbsent(id, 0);
        }
        filter.getCondition().accept((org.apache.calcite.rex.RexVisitor)this.rexVisitor);
        return (RelNode)super.visit(filter);
    }

    @Override
    public RelNode visit(Correlate correlate) throws RuntimeException {
        for (CorrelationId id : correlate.getVariablesSet()) {
            this.nestedDepth.putIfAbsent(id, 0);
        }
        this.apply(correlate.getLeft());
        this.nestedDepth.replaceAll((k, v) -> v + 1);
        this.apply(correlate.getRight());
        this.nestedDepth.replaceAll((k, v) -> v - 1);
        return correlate;
    }

    @Override
    public RelNode visitOther(RelNode other) throws RuntimeException {
        for (RelNode child : other.getInputs()) {
            this.apply(child);
        }
        return other;
    }

    @Override
    public RelNode visit(Project project) throws RuntimeException {
        for (CorrelationId id : project.getVariablesSet()) {
            this.nestedDepth.putIfAbsent(id, 0);
        }
        for (RexSubQuery subQuery : RexUtil.SubQueryCollector.collect((Project)project)) {
            subQuery.accept((org.apache.calcite.rex.RexVisitor)this.rexVisitor);
        }
        return (RelNode)super.visit(project);
    }

    private static class RexVisitor
    extends RexShuttle {
        final OuterReferenceResolver referenceResolver;

        RexVisitor(OuterReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public RexNode visitSubQuery(RexSubQuery subQuery) {
            this.referenceResolver.nestedDepth.replaceAll((k, v) -> v + 1);
            this.referenceResolver.apply(subQuery.rel);
            this.referenceResolver.nestedDepth.replaceAll((k, v) -> v - 1);
            return subQuery;
        }

        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            CorrelationId id;
            if (fieldAccess.getReferenceExpr() instanceof RexCorrelVariable && this.referenceResolver.nestedDepth.containsKey(id = ((RexCorrelVariable)fieldAccess.getReferenceExpr()).id)) {
                this.referenceResolver.fieldAccessDepthMap.put(fieldAccess, this.referenceResolver.nestedDepth.get(id));
            }
            return fieldAccess;
        }
    }
}

