/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import io.substrait.expression.Expression;
import io.substrait.extendedexpression.ExtendedExpression;
import io.substrait.extendedexpression.ExtendedExpressionProtoConverter;
import io.substrait.extendedexpression.ImmutableExpressionReference;
import io.substrait.extendedexpression.ImmutableExtendedExpression;
import io.substrait.extension.SimpleExtension;
import io.substrait.isthmus.FeatureBoard;
import io.substrait.isthmus.SqlConverterBase;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.calcite.SubstraitTable;
import io.substrait.isthmus.expression.RexExpressionConverter;
import io.substrait.isthmus.expression.ScalarFunctionConverter;
import io.substrait.isthmus.sql.SubstraitCreateStatementParser;
import io.substrait.isthmus.sql.SubstraitSqlValidator;
import io.substrait.type.NamedStruct;
import io.substrait.type.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;

public class SqlExpressionToSubstrait
extends SqlConverterBase {
    protected final RexExpressionConverter rexConverter;

    public SqlExpressionToSubstrait() {
        this(FEATURES_DEFAULT, EXTENSION_COLLECTION);
    }

    public SqlExpressionToSubstrait(FeatureBoard features, SimpleExtension.ExtensionCollection extensions) {
        super(features);
        ScalarFunctionConverter scalarFunctionConverter = new ScalarFunctionConverter(extensions.scalarFunctions(), this.factory);
        this.rexConverter = new RexExpressionConverter(scalarFunctionConverter);
    }

    public io.substrait.proto.ExtendedExpression convert(String sqlExpression, List<String> createStatements) throws SqlParseException {
        return this.convert(new String[]{sqlExpression}, createStatements);
    }

    public io.substrait.proto.ExtendedExpression convert(String[] sqlExpressions, List<String> createStatements) throws SqlParseException {
        Result result = this.registerCreateTablesForExtendedExpression(createStatements);
        return this.executeInnerSQLExpressions(sqlExpressions, result.validator, result.catalogReader, result.nameToTypeMap, result.nameToNodeMap);
    }

    private io.substrait.proto.ExtendedExpression executeInnerSQLExpressions(String[] sqlExpressions, SqlValidator validator, CalciteCatalogReader catalogReader, Map<String, RelDataType> nameToTypeMap, Map<String, RexNode> nameToNodeMap) throws SqlParseException {
        int columnIndex = 1;
        ArrayList<ImmutableExpressionReference> expressionReferences = new ArrayList<ImmutableExpressionReference>();
        for (String sqlExpression : sqlExpressions) {
            RexNode rexNode = this.sqlToRexNode(sqlExpression.trim(), validator, catalogReader, nameToTypeMap, nameToNodeMap);
            ImmutableExpressionReference expressionReference = ExtendedExpression.ExpressionReference.builder().expression((Expression)rexNode.accept((RexVisitor)this.rexConverter)).addOutputNames("column-" + columnIndex++).build();
            expressionReferences.add(expressionReference);
        }
        NamedStruct namedStruct = this.toNamedStruct(nameToTypeMap);
        ImmutableExtendedExpression.Builder extendedExpression = ExtendedExpression.builder().referredExpressions(expressionReferences).baseSchema(namedStruct);
        return new ExtendedExpressionProtoConverter().toProto((ExtendedExpression)extendedExpression.build());
    }

    private RexNode sqlToRexNode(String sql, SqlValidator validator, CalciteCatalogReader catalogReader, Map<String, RelDataType> nameToTypeMap, Map<String, RexNode> nameToNodeMap) throws SqlParseException {
        SqlParser parser = SqlParser.create((String)sql, (SqlParser.Config)this.parserConfig);
        SqlNode sqlNode = parser.parseExpression();
        SqlNode validSqlNode = validator.validateParameterizedExpression(sqlNode, nameToTypeMap);
        SqlToRelConverter converter = new SqlToRelConverter(null, validator, (Prepare.CatalogReader)catalogReader, this.relOptCluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, this.converterConfig);
        return converter.convertExpression(validSqlNode, nameToNodeMap);
    }

    private Result registerCreateTablesForExtendedExpression(List<String> tables) throws SqlParseException {
        LinkedHashMap<String, RelDataType> nameToTypeMap = new LinkedHashMap<String, RelDataType>();
        HashMap<String, RexNode> nameToNodeMap = new HashMap<String, RexNode>();
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)false);
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(rootSchema, List.of(), this.factory, this.config);
        if (tables != null) {
            for (String tableDef : tables) {
                List<SubstraitTable> tList = SubstraitCreateStatementParser.processCreateStatements(tableDef);
                for (SubstraitTable t : tList) {
                    rootSchema.add(t.getName(), (Table)t);
                    for (RelDataTypeField field : t.getRowType(this.factory).getFieldList()) {
                        nameToTypeMap.merge(field.getName(), field.getType(), (v1, v2) -> {
                            throw new IllegalArgumentException("There is no support for duplicate column names: " + field.getName());
                        });
                        nameToNodeMap.merge(field.getName(), (RexNode)new RexInputRef(field.getIndex(), field.getType()), (v1, v2) -> {
                            throw new IllegalArgumentException("There is no support for duplicate column names: " + field.getName());
                        });
                    }
                }
            }
        }
        SubstraitSqlValidator validator = new SubstraitSqlValidator((Prepare.CatalogReader)catalogReader);
        return new Result((SqlValidator)validator, catalogReader, nameToTypeMap, nameToNodeMap);
    }

    private NamedStruct toNamedStruct(Map<String, RelDataType> nameToTypeMap) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Type> types = new ArrayList<Type>();
        for (Map.Entry<String, RelDataType> entry : nameToTypeMap.entrySet()) {
            String k = entry.getKey();
            RelDataType v = entry.getValue();
            names.add(k);
            types.add(TypeConverter.DEFAULT.toSubstrait(v));
        }
        return NamedStruct.of(names, (Type.Struct)Type.Struct.builder().fields(types).nullable(false).build());
    }

    private static final class Result {
        final SqlValidator validator;
        final CalciteCatalogReader catalogReader;
        final Map<String, RelDataType> nameToTypeMap;
        final Map<String, RexNode> nameToNodeMap;

        Result(SqlValidator validator, CalciteCatalogReader catalogReader, Map<String, RelDataType> nameToTypeMap, Map<String, RexNode> nameToNodeMap) {
            this.validator = validator;
            this.catalogReader = catalogReader;
            this.nameToTypeMap = nameToTypeMap;
            this.nameToNodeMap = nameToNodeMap;
        }
    }
}

