/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import io.substrait.extension.SimpleExtension;
import io.substrait.isthmus.SchemaCollector;
import io.substrait.isthmus.SqlKindFromRel;
import io.substrait.isthmus.SubstraitRelNodeConverter;
import io.substrait.isthmus.TypeConverter;
import io.substrait.plan.Plan;
import io.substrait.relation.NamedScan;
import io.substrait.relation.Rel;
import io.substrait.relation.RelCopyOnWriteVisitor;
import io.substrait.relation.RelVisitor;
import io.substrait.type.NamedStruct;
import io.substrait.util.EmptyVisitationContext;
import io.substrait.util.VisitationContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Pair;

public class SubstraitToCalcite {
    protected final SimpleExtension.ExtensionCollection extensions;
    protected final RelDataTypeFactory typeFactory;
    protected final TypeConverter typeConverter;
    protected final Prepare.CatalogReader catalogReader;

    public SubstraitToCalcite(SimpleExtension.ExtensionCollection extensions, RelDataTypeFactory typeFactory) {
        this(extensions, typeFactory, TypeConverter.DEFAULT, null);
    }

    public SubstraitToCalcite(SimpleExtension.ExtensionCollection extensions, RelDataTypeFactory typeFactory, Prepare.CatalogReader catalogReader) {
        this(extensions, typeFactory, TypeConverter.DEFAULT, catalogReader);
    }

    public SubstraitToCalcite(SimpleExtension.ExtensionCollection extensions, RelDataTypeFactory typeFactory, TypeConverter typeConverter) {
        this(extensions, typeFactory, typeConverter, null);
    }

    public SubstraitToCalcite(SimpleExtension.ExtensionCollection extensions, RelDataTypeFactory typeFactory, TypeConverter typeConverter, Prepare.CatalogReader catalogReader) {
        this.extensions = extensions;
        this.typeFactory = typeFactory;
        this.typeConverter = typeConverter;
        this.catalogReader = catalogReader;
    }

    protected CalciteSchema toSchema(Rel rel) {
        SchemaCollector schemaCollector = new SchemaCollector(this.typeFactory, this.typeConverter);
        return schemaCollector.toSchema(rel);
    }

    protected RelBuilder createRelBuilder(CalciteSchema schema) {
        return RelBuilder.create((FrameworkConfig)Frameworks.newConfigBuilder().defaultSchema(schema.plus()).build());
    }

    protected SubstraitRelNodeConverter createSubstraitRelNodeConverter(RelBuilder relBuilder) {
        return new SubstraitRelNodeConverter(this.extensions, this.typeFactory, relBuilder);
    }

    public RelNode convert(Rel rel) {
        RelBuilder relBuilder;
        if (this.catalogReader != null) {
            relBuilder = this.createRelBuilder(this.catalogReader.getRootSchema());
        } else {
            CalciteSchema rootSchema = this.toSchema(rel);
            relBuilder = this.createRelBuilder(rootSchema);
        }
        SubstraitRelNodeConverter converter = this.createSubstraitRelNodeConverter(relBuilder);
        return (RelNode)rel.accept((RelVisitor)converter, (VisitationContext)SubstraitRelNodeConverter.Context.newContext());
    }

    public RelRoot convert(Plan.Root root) {
        RelNode convertedNode = this.convert(root.getInput());
        if (convertedNode instanceof TableModify) {
            SqlKind kind;
            TableModify tableModify = (TableModify)convertedNode;
            RelDataType tableRowType = tableModify.getTable().getRowType();
            switch (tableModify.getOperation()) {
                case INSERT: {
                    kind = SqlKind.INSERT;
                    break;
                }
                case UPDATE: {
                    kind = SqlKind.UPDATE;
                    break;
                }
                case DELETE: {
                    kind = SqlKind.DELETE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported table modify operation: " + String.valueOf(tableModify.getOperation()));
                }
            }
            return RelRoot.of((RelNode)tableModify, (RelDataType)tableRowType, (SqlKind)kind);
        }
        SqlKindFromRel sqlKindFromRel = new SqlKindFromRel();
        SqlKind kind = (SqlKind)root.getInput().accept((RelVisitor)sqlKindFromRel, (VisitationContext)EmptyVisitationContext.INSTANCE);
        RelDataType inputRowType = convertedNode.getRowType();
        RelDataType newRowType = (RelDataType)this.renameFields((RelDataType)inputRowType, (List<String>)root.getNames(), (Integer)Integer.valueOf((int)0)).right;
        return RelRoot.of((RelNode)convertedNode, (RelDataType)newRowType, (SqlKind)kind);
    }

    private Pair<Integer, RelDataType> renameFields(RelDataType type, List<String> names, Integer currentIndex) {
        Integer nextIndex = currentIndex;
        switch (type.getSqlTypeName()) {
            case ROW: 
            case STRUCTURED: {
                ArrayList<String> newFieldNames = new ArrayList<String>();
                ArrayList<RelDataType> renamedFields = new ArrayList<RelDataType>();
                for (RelDataTypeField field : type.getFieldList()) {
                    newFieldNames.add(names.get(nextIndex));
                    Pair<Integer, RelDataType> p = this.renameFields(field.getType(), names, nextIndex + 1);
                    renamedFields.add((RelDataType)p.right);
                    nextIndex = (Integer)p.left;
                }
                return Pair.of((Object)nextIndex, (Object)this.typeFactory.createStructType(type.getStructKind(), renamedFields, newFieldNames));
            }
            case ARRAY: 
            case MULTISET: {
                Pair<Integer, RelDataType> renamedElementType = this.renameFields(type.getComponentType(), names, nextIndex);
                return Pair.of((Object)((Integer)renamedElementType.left), (Object)this.typeFactory.createArrayType((RelDataType)renamedElementType.right, -1L));
            }
            case MAP: {
                Pair<Integer, RelDataType> renamedKeyType = this.renameFields(type.getKeyType(), names, nextIndex);
                Pair<Integer, RelDataType> renamedValueType = this.renameFields(type.getValueType(), names, (Integer)renamedKeyType.left);
                return Pair.of((Object)((Integer)renamedValueType.left), (Object)this.typeFactory.createMapType((RelDataType)renamedKeyType.right, (RelDataType)renamedValueType.right));
            }
        }
        return Pair.of((Object)currentIndex, (Object)type);
    }

    private static class NamedStructGatherer
    extends RelCopyOnWriteVisitor<RuntimeException> {
        Map<List<String>, NamedStruct> tableMap = new HashMap<List<String>, NamedStruct>();

        private NamedStructGatherer() {
        }

        public static Map<List<String>, NamedStruct> gatherTables(Rel rel) {
            NamedStructGatherer visitor = new NamedStructGatherer();
            rel.accept((RelVisitor)visitor, (VisitationContext)EmptyVisitationContext.INSTANCE);
            return visitor.tableMap;
        }

        public Optional<Rel> visit(NamedScan namedScan, EmptyVisitationContext context) {
            Optional result = super.visit(namedScan, context);
            List tableName = namedScan.getNames();
            this.tableMap.put(tableName, namedScan.getInitialSchema());
            return result;
        }
    }
}

