/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.calcite.rel;

import io.substrait.isthmus.calcite.rel.CreateTable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.ddl.SqlCreateTable;
import org.apache.calcite.sql.ddl.SqlCreateView;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql2rel.SqlToRelConverter;

public class DdlSqlToRelConverter
extends SqlBasicVisitor<RelRoot> {
    protected final Map<Class<? extends SqlCall>, Function<SqlCall, RelRoot>> ddlHandlers = new ConcurrentHashMap<Class<? extends SqlCall>, Function<SqlCall, RelRoot>>();
    private final SqlToRelConverter converter;

    private Function<SqlCall, RelRoot> findDdlHandler(SqlCall call) {
        Class<?> currentClass = call.getClass();
        while (SqlCall.class.isAssignableFrom(currentClass)) {
            Function<SqlCall, RelRoot> found = this.ddlHandlers.get(currentClass);
            if (found != null) {
                return found;
            }
            currentClass = currentClass.getSuperclass();
        }
        return null;
    }

    public DdlSqlToRelConverter(SqlToRelConverter converter) {
        this.converter = converter;
        this.ddlHandlers.put(SqlCreateTable.class, sqlCall -> this.handleCreateTable((SqlCreateTable)sqlCall));
        this.ddlHandlers.put(SqlCreateView.class, sqlCall -> this.handleCreateView((SqlCreateView)sqlCall));
    }

    public RelRoot visit(SqlCall sqlCall) {
        Function<SqlCall, RelRoot> ddlHandler = this.findDdlHandler(sqlCall);
        if (ddlHandler != null) {
            return ddlHandler.apply(sqlCall);
        }
        return this.handleNonDdl((SqlNode)sqlCall);
    }

    protected RelRoot handleNonDdl(SqlNode sqlNode) {
        return this.converter.convertQuery(sqlNode, true, true);
    }

    protected RelRoot handleCreateTable(SqlCreateTable sqlCreateTable) {
        if (sqlCreateTable.query == null) {
            throw new IllegalArgumentException("Only create table as select statements are supported");
        }
        RelNode input = this.converter.convertQuery((SqlNode)sqlCreateTable.query, (boolean)true, (boolean)true).rel;
        return RelRoot.of((RelNode)new CreateTable((List<String>)sqlCreateTable.name.names, input), (SqlKind)sqlCreateTable.getKind());
    }

    protected RelRoot handleCreateView(SqlCreateView sqlCreateView) {
        RelNode input = this.converter.convertQuery((SqlNode)sqlCreateView.query, (boolean)true, (boolean)true).rel;
        return RelRoot.of((RelNode)new CreateTable((List<String>)sqlCreateView.name.names, input), (SqlKind)sqlCreateView.getKind());
    }
}

