/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.sql;

import io.substrait.isthmus.SubstraitTypeSystem;
import io.substrait.isthmus.calcite.rel.DdlSqlToRelConverter;
import io.substrait.isthmus.sql.SubstraitSqlStatementParser;
import io.substrait.isthmus.sql.SubstraitSqlValidator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;

public class SubstraitSqlToCalcite {
    public static RelRoot convertQuery(String sqlStatement, Prepare.CatalogReader catalogReader) throws SqlParseException {
        SubstraitSqlValidator validator = new SubstraitSqlValidator(catalogReader);
        return SubstraitSqlToCalcite.convertQuery(sqlStatement, catalogReader, (SqlValidator)validator, SubstraitSqlToCalcite.createDefaultRelOptCluster());
    }

    public static RelRoot convertQuery(String sqlStatement, Prepare.CatalogReader catalogReader, SqlValidator validator, RelOptCluster cluster) throws SqlParseException {
        List<SqlNode> sqlNodes = SubstraitSqlStatementParser.parseStatements(sqlStatement);
        if (sqlNodes.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected one statement, found: %d", sqlNodes.size()));
        }
        List<RelRoot> relRoots = SubstraitSqlToCalcite.convert(sqlNodes, catalogReader, validator, cluster);
        return relRoots.get(0);
    }

    public static List<RelRoot> convertQueries(String sqlStatements, Prepare.CatalogReader catalogReader) throws SqlParseException {
        SubstraitSqlValidator validator = new SubstraitSqlValidator(catalogReader);
        return SubstraitSqlToCalcite.convertQueries(sqlStatements, catalogReader, (SqlValidator)validator, SubstraitSqlToCalcite.createDefaultRelOptCluster());
    }

    public static List<RelRoot> convertQueries(String sqlStatements, Prepare.CatalogReader catalogReader, SqlValidator validator, RelOptCluster cluster) throws SqlParseException {
        List<SqlNode> sqlNodes = SubstraitSqlStatementParser.parseStatements(sqlStatements);
        return SubstraitSqlToCalcite.convert(sqlNodes, catalogReader, validator, cluster);
    }

    static List<RelRoot> convert(List<SqlNode> sqlNodes, Prepare.CatalogReader catalogReader, SqlValidator validator, RelOptCluster cluster) {
        RelOptTable.ViewExpander viewExpander = null;
        SqlToRelConverter converter = new SqlToRelConverter(viewExpander, validator, catalogReader, cluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, SqlToRelConverter.CONFIG);
        boolean needsValidation = true;
        boolean top = true;
        DdlSqlToRelConverter ddlSqlToRelConverter = new DdlSqlToRelConverter(converter);
        return sqlNodes.stream().map(sqlNode -> {
            RelRoot relRoot = (RelRoot)sqlNode.accept((SqlVisitor)ddlSqlToRelConverter);
            if (relRoot == null) {
                relRoot = SubstraitSqlToCalcite.removeRedundantProjects(converter.convertQuery(sqlNode, needsValidation, top));
            }
            return relRoot;
        }).collect(Collectors.toList());
    }

    static RelOptCluster createDefaultRelOptCluster() {
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl(SubstraitTypeSystem.TYPE_SYSTEM));
        HepProgram program = HepProgram.builder().build();
        HepPlanner emptyPlanner = new HepPlanner(program);
        return RelOptCluster.create((RelOptPlanner)emptyPlanner, (RexBuilder)rexBuilder);
    }

    static RelRoot removeRedundantProjects(RelRoot root) {
        return root.withRel(SubstraitSqlToCalcite.removeRedundantProjects(root.rel));
    }

    static RelNode removeRedundantProjects(RelNode root) {
        HepProgram program = HepProgram.builder().addRuleInstance((RelOptRule)CoreRules.PROJECT_REMOVE).build();
        HepPlanner planner = new HepPlanner(program);
        planner.setRoot(root);
        return planner.findBestExp();
    }
}

