/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import io.substrait.function.TypeExpression;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.calcite.SubstraitSchema;
import io.substrait.isthmus.calcite.SubstraitTable;
import io.substrait.relation.NamedScan;
import io.substrait.relation.NamedUpdate;
import io.substrait.relation.NamedWrite;
import io.substrait.relation.Rel;
import io.substrait.relation.RelCopyOnWriteVisitor;
import io.substrait.relation.RelVisitor;
import io.substrait.type.NamedStruct;
import io.substrait.util.EmptyVisitationContext;
import io.substrait.util.VisitationContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Table;

public class SchemaCollector {
    private static final boolean CASE_SENSITIVE = false;
    private final RelDataTypeFactory typeFactory;
    private final TypeConverter typeConverter;

    public SchemaCollector(RelDataTypeFactory typeFactory, TypeConverter typeConverter) {
        this.typeFactory = typeFactory;
        this.typeConverter = typeConverter;
    }

    public CalciteSchema toSchema(Rel rel) {
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)false, (boolean)false);
        for (Map.Entry<List<String>, NamedStruct> entry : TableGatherer.gatherTables(rel).entrySet()) {
            List<String> names = entry.getKey();
            NamedStruct namedStruct = entry.getValue();
            String tableName = names.get(names.size() - 1);
            CalciteSchema schema = rootSchema;
            for (String schemaName : names.subList(0, names.size() - 1)) {
                CalciteSchema subSchema = schema.getSubSchema(schemaName, false);
                if (subSchema != null) {
                    schema = subSchema;
                    continue;
                }
                SubstraitSchema newSubSchema = new SubstraitSchema();
                schema = schema.add(schemaName, (Schema)newSubSchema);
            }
            CalciteSchema.TableEntry table = schema.getTable(tableName, false);
            if (table != null) continue;
            RelDataType rowType = this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)namedStruct.struct(), namedStruct.names());
            schema.add(tableName, (Table)new SubstraitTable(tableName, rowType));
        }
        return rootSchema;
    }

    static class TableGatherer
    extends RelCopyOnWriteVisitor<RuntimeException> {
        Map<List<String>, NamedStruct> tableMap = new HashMap<List<String>, NamedStruct>();

        private TableGatherer() {
        }

        public static Map<List<String>, NamedStruct> gatherTables(Rel rootRel) {
            TableGatherer visitor = new TableGatherer();
            rootRel.accept((RelVisitor)visitor, (VisitationContext)EmptyVisitationContext.INSTANCE);
            return visitor.tableMap;
        }

        public Optional<Rel> visit(NamedScan namedScan, EmptyVisitationContext context) {
            NamedStruct existingSchema;
            super.visit(namedScan, context);
            List tableName = namedScan.getNames();
            if (this.tableMap.containsKey(tableName) && !(existingSchema = this.tableMap.get(tableName)).equals(namedScan.getInitialSchema())) {
                throw new IllegalArgumentException(String.format("NamedScan for %s is present multiple times with different schemas", tableName));
            }
            this.tableMap.put(tableName, namedScan.getInitialSchema());
            return Optional.empty();
        }

        public Optional<Rel> visit(NamedWrite namedWrite, EmptyVisitationContext context) {
            NamedStruct existingSchema;
            super.visit(namedWrite, context);
            List tableName = namedWrite.getNames();
            if (this.tableMap.containsKey(tableName) && !(existingSchema = this.tableMap.get(tableName)).equals(namedWrite.getTableSchema())) {
                throw new IllegalArgumentException(String.format("NamedWrite for %s is present multiple times with different schemas", tableName));
            }
            this.tableMap.put(tableName, namedWrite.getTableSchema());
            return Optional.empty();
        }

        public Optional<Rel> visit(NamedUpdate namedUpdate, EmptyVisitationContext context) {
            NamedStruct existingSchema;
            super.visit(namedUpdate, context);
            List tableName = namedUpdate.getNames();
            if (this.tableMap.containsKey(tableName) && !(existingSchema = this.tableMap.get(tableName)).equals(namedUpdate.getTableSchema())) {
                throw new IllegalArgumentException(String.format("NamedUpdate for %s is present multiple times with different schemas", tableName));
            }
            this.tableMap.put(tableName, namedUpdate.getTableSchema());
            return Optional.empty();
        }
    }
}

