/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import io.substrait.expression.Expression;
import io.substrait.isthmus.expression.RexExpressionConverter;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;

public class SortFieldConverter {
    public static Expression.SortField toSortField(RexFieldCollation rexFieldCollation, RexExpressionConverter rexExpressionConverter) {
        Expression expr = (Expression)((RexNode)rexFieldCollation.left).accept((RexVisitor)rexExpressionConverter);
        Expression.SortDirection direction = SortFieldConverter.asSortDirection(rexFieldCollation);
        return Expression.SortField.builder().expr(expr).direction(direction).build();
    }

    private static Expression.SortDirection asSortDirection(RexFieldCollation collation) {
        RelFieldCollation.Direction direction = collation.getDirection();
        if (direction == RelFieldCollation.Direction.ASCENDING) {
            return collation.getNullDirection() == RelFieldCollation.NullDirection.LAST ? Expression.SortDirection.ASC_NULLS_LAST : Expression.SortDirection.ASC_NULLS_FIRST;
        }
        if (direction == RelFieldCollation.Direction.DESCENDING) {
            return collation.getNullDirection() == RelFieldCollation.NullDirection.LAST ? Expression.SortDirection.DESC_NULLS_LAST : Expression.SortDirection.DESC_NULLS_FIRST;
        }
        throw new IllegalArgumentException(String.format("Unexpected RelFieldCollation.Direction:%s enum at the RexFieldCollation!", direction));
    }
}

