/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import java.util.Optional;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlAvgAggFunction;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.sql.type.ReturnTypes;

public class AggregateFunctions {
    public static SqlAggFunction MIN = new SubstraitSqlMinMaxAggFunction(SqlKind.MIN);
    public static SqlAggFunction MAX = new SubstraitSqlMinMaxAggFunction(SqlKind.MAX);
    public static SqlAggFunction AVG = new SubstraitAvgAggFunction(SqlKind.AVG);
    public static SqlAggFunction SUM = new SubstraitSumAggFunction();
    public static SqlAggFunction SUM0 = new SubstraitSumEmptyIsZeroAggFunction();

    public static Optional<SqlAggFunction> toSubstraitAggVariant(SqlAggFunction aggFunction) {
        if (aggFunction instanceof SqlMinMaxAggFunction) {
            SqlMinMaxAggFunction fun = (SqlMinMaxAggFunction)aggFunction;
            return Optional.of(fun.getKind() == SqlKind.MIN ? MIN : MAX);
        }
        if (aggFunction instanceof SqlAvgAggFunction) {
            return Optional.of(AVG);
        }
        if (aggFunction instanceof SqlSumAggFunction) {
            return Optional.of(SUM);
        }
        if (aggFunction instanceof SqlSumEmptyIsZeroAggFunction) {
            return Optional.of(SUM0);
        }
        return Optional.empty();
    }

    private static class SubstraitSqlMinMaxAggFunction
    extends SqlMinMaxAggFunction {
        public SubstraitSqlMinMaxAggFunction(SqlKind kind) {
            super(kind);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return ReturnTypes.ARG0_FORCE_NULLABLE.inferReturnType(opBinding);
        }
    }

    private static class SubstraitAvgAggFunction
    extends SqlAvgAggFunction {
        public SubstraitAvgAggFunction(SqlKind kind) {
            super(kind);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return ReturnTypes.ARG0_FORCE_NULLABLE.inferReturnType(opBinding);
        }
    }

    private static class SubstraitSumAggFunction
    extends SqlSumAggFunction {
        public SubstraitSumAggFunction() {
            super(null);
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return ReturnTypes.ARG0_FORCE_NULLABLE.inferReturnType(opBinding);
        }
    }

    private static class SubstraitSumEmptyIsZeroAggFunction
    extends SqlSumEmptyIsZeroAggFunction {
        public String getName() {
            return "sum0";
        }

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return ReturnTypes.BIGINT.inferReturnType(opBinding);
        }
    }
}

