/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import io.substrait.expression.Expression;
import io.substrait.expression.ExpressionVisitor;
import io.substrait.expression.FunctionArg;
import io.substrait.extension.SimpleExtension;
import io.substrait.function.TypeExpression;
import io.substrait.isthmus.PreCalciteAggregateValidator;
import io.substrait.isthmus.SqlConverterBase;
import io.substrait.isthmus.TypeConverter;
import io.substrait.isthmus.calcite.rel.CreateTable;
import io.substrait.isthmus.calcite.rel.CreateView;
import io.substrait.isthmus.expression.AggregateFunctionConverter;
import io.substrait.isthmus.expression.ExpressionRexConverter;
import io.substrait.isthmus.expression.ScalarFunctionConverter;
import io.substrait.isthmus.expression.WindowFunctionConverter;
import io.substrait.relation.AbstractDdlRel;
import io.substrait.relation.AbstractRelVisitor;
import io.substrait.relation.AbstractUpdate;
import io.substrait.relation.AbstractWriteRel;
import io.substrait.relation.Aggregate;
import io.substrait.relation.Cross;
import io.substrait.relation.EmptyScan;
import io.substrait.relation.Fetch;
import io.substrait.relation.Filter;
import io.substrait.relation.Join;
import io.substrait.relation.LocalFiles;
import io.substrait.relation.NamedDdl;
import io.substrait.relation.NamedScan;
import io.substrait.relation.NamedUpdate;
import io.substrait.relation.NamedWrite;
import io.substrait.relation.Project;
import io.substrait.relation.Rel;
import io.substrait.relation.RelVisitor;
import io.substrait.relation.Sort;
import io.substrait.relation.VirtualTableScan;
import io.substrait.type.NamedStruct;
import io.substrait.type.TypeCreator;
import io.substrait.util.VisitationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.RelBuilder;

public class SubstraitRelNodeConverter
extends AbstractRelVisitor<RelNode, Context, RuntimeException> {
    protected final RelDataTypeFactory typeFactory;
    protected final ScalarFunctionConverter scalarFunctionConverter;
    protected final AggregateFunctionConverter aggregateFunctionConverter;
    protected final ExpressionRexConverter expressionRexConverter;
    protected final RelBuilder relBuilder;
    protected final RexBuilder rexBuilder;
    private final TypeConverter typeConverter;

    public SubstraitRelNodeConverter(SimpleExtension.ExtensionCollection extensions, RelDataTypeFactory typeFactory, RelBuilder relBuilder) {
        this(typeFactory, relBuilder, new ScalarFunctionConverter(extensions.scalarFunctions(), typeFactory), new AggregateFunctionConverter(extensions.aggregateFunctions(), typeFactory), new WindowFunctionConverter(extensions.windowFunctions(), typeFactory), TypeConverter.DEFAULT);
    }

    public SubstraitRelNodeConverter(RelDataTypeFactory typeFactory, RelBuilder relBuilder, ScalarFunctionConverter scalarFunctionConverter, AggregateFunctionConverter aggregateFunctionConverter, WindowFunctionConverter windowFunctionConverter, TypeConverter typeConverter) {
        this(typeFactory, relBuilder, scalarFunctionConverter, aggregateFunctionConverter, windowFunctionConverter, typeConverter, new ExpressionRexConverter(typeFactory, scalarFunctionConverter, windowFunctionConverter, typeConverter));
    }

    public SubstraitRelNodeConverter(RelDataTypeFactory typeFactory, RelBuilder relBuilder, ScalarFunctionConverter scalarFunctionConverter, AggregateFunctionConverter aggregateFunctionConverter, WindowFunctionConverter windowFunctionConverter, TypeConverter typeConverter, ExpressionRexConverter expressionRexConverter) {
        this.typeFactory = typeFactory;
        this.typeConverter = typeConverter;
        this.relBuilder = relBuilder;
        this.rexBuilder = new RexBuilder(typeFactory);
        this.scalarFunctionConverter = scalarFunctionConverter;
        this.aggregateFunctionConverter = aggregateFunctionConverter;
        this.expressionRexConverter = expressionRexConverter;
        this.expressionRexConverter.setRelNodeConverter(this);
    }

    public static RelNode convert(Rel relRoot, RelOptCluster relOptCluster, Prepare.CatalogReader catalogReader, SqlParser.Config parserConfig) {
        RelBuilder relBuilder = RelBuilder.create((FrameworkConfig)Frameworks.newConfigBuilder().parserConfig(parserConfig).defaultSchema(catalogReader.getRootSchema().plus()).traitDefs((List)null).programs(new Program[0]).build());
        return (RelNode)relRoot.accept((RelVisitor)new SubstraitRelNodeConverter(SqlConverterBase.EXTENSION_COLLECTION, relOptCluster.getTypeFactory(), relBuilder), (VisitationContext)Context.newContext());
    }

    public RelNode visit(Filter filter, Context context) throws RuntimeException {
        RelNode input = (RelNode)filter.getInput().accept((RelVisitor)this, (VisitationContext)context);
        context.pushOuterRowType(input.getRowType());
        RexNode filterCondition = (RexNode)filter.getCondition().accept((ExpressionVisitor)this.expressionRexConverter, (VisitationContext)context);
        RelNode node = this.relBuilder.push(input).filter(context.popCorrelationIds(), new RexNode[]{filterCondition}).build();
        context.popOuterRowType();
        return this.applyRemap(node, filter.getRemap());
    }

    public RelNode visit(NamedScan namedScan, Context context) throws RuntimeException {
        RelNode node = this.relBuilder.scan((Iterable)namedScan.getNames()).build();
        return this.applyRemap(node, namedScan.getRemap());
    }

    public RelNode visit(LocalFiles localFiles, Context context) throws RuntimeException {
        return this.visitFallback((Rel)localFiles, context);
    }

    public RelNode visit(EmptyScan emptyScan, Context context) throws RuntimeException {
        RelDataType rowType = this.typeConverter.toCalcite(this.relBuilder.getTypeFactory(), (TypeExpression)emptyScan.getInitialSchema().struct());
        LogicalValues node = LogicalValues.create((RelOptCluster)this.relBuilder.getCluster(), (RelDataType)rowType, (ImmutableList)ImmutableList.of());
        return this.applyRemap((RelNode)node, emptyScan.getRemap());
    }

    public RelNode visit(Project project, Context context) throws RuntimeException {
        RelNode child = (RelNode)project.getInput().accept((RelVisitor)this, (VisitationContext)context);
        context.pushOuterRowType(child.getRowType());
        Stream<RexNode> directOutputs = IntStream.range(0, child.getRowType().getFieldCount()).mapToObj(fieldIndex -> this.rexBuilder.makeInputRef(child, fieldIndex));
        Stream<RexNode> exprs = project.getExpressions().stream().map(expr -> (RexNode)expr.accept((ExpressionVisitor)this.expressionRexConverter, (VisitationContext)context));
        List rexExprs = Stream.concat(directOutputs, exprs).collect(Collectors.toList());
        RelNode node = this.relBuilder.push(child).project(rexExprs, List.of(), false, context.popCorrelationIds()).build();
        context.popOuterRowType();
        return this.applyRemap(node, project.getRemap());
    }

    public RelNode visit(Cross cross, Context context) throws RuntimeException {
        RelNode left = (RelNode)cross.getLeft().accept((RelVisitor)this, (VisitationContext)context);
        RelNode right = (RelNode)cross.getRight().accept((RelVisitor)this, (VisitationContext)context);
        RelNode node = this.relBuilder.push(left).push(right).join(JoinRelType.INNER, (RexNode)this.relBuilder.literal((Object)true)).build();
        return this.applyRemap(node, cross.getRemap());
    }

    public RelNode visit(Join join, Context context) throws RuntimeException {
        RelNode left = (RelNode)join.getLeft().accept((RelVisitor)this, (VisitationContext)context);
        RelNode right = (RelNode)join.getRight().accept((RelVisitor)this, (VisitationContext)context);
        context.pushOuterRowType(left.getRowType(), right.getRowType());
        RexNode condition = join.getCondition().map(c -> (RexNode)c.accept((ExpressionVisitor)this.expressionRexConverter, (VisitationContext)context)).orElse((RexNode)this.relBuilder.literal((Object)true));
        JoinRelType joinType = this.asJoinRelType(join);
        RelNode node = this.relBuilder.push(left).push(right).join(joinType, condition, context.popCorrelationIds()).build();
        context.popOuterRowType();
        return this.applyRemap(node, join.getRemap());
    }

    private JoinRelType asJoinRelType(Join join) {
        Join.JoinType type = join.getJoinType();
        if (type == Join.JoinType.INNER) {
            return JoinRelType.INNER;
        }
        if (type == Join.JoinType.LEFT) {
            return JoinRelType.LEFT;
        }
        if (type == Join.JoinType.RIGHT) {
            return JoinRelType.RIGHT;
        }
        if (type == Join.JoinType.OUTER) {
            return JoinRelType.FULL;
        }
        if (type == Join.JoinType.SEMI) {
            return JoinRelType.SEMI;
        }
        if (type == Join.JoinType.ANTI) {
            return JoinRelType.ANTI;
        }
        if (type == Join.JoinType.LEFT_SEMI) {
            return JoinRelType.SEMI;
        }
        if (type == Join.JoinType.LEFT_ANTI) {
            return JoinRelType.ANTI;
        }
        if (type == Join.JoinType.UNKNOWN) {
            throw new UnsupportedOperationException("Unknown join type is not supported");
        }
        throw new UnsupportedOperationException("Unsupported join type: " + join.getJoinType().name());
    }

    public RelNode visit(io.substrait.relation.Set set, Context context) throws RuntimeException {
        set.getInputs().forEach(input -> this.relBuilder.push((RelNode)input.accept((RelVisitor)this, (VisitationContext)context)));
        RelBuilder builder = this.getRelBuilder(set);
        RelNode node = builder.build();
        return this.applyRemap(node, set.getRemap());
    }

    private RelBuilder getRelBuilder(io.substrait.relation.Set set) {
        int numInputs = set.getInputs().size();
        switch (set.getSetOp()) {
            case MINUS_PRIMARY: {
                return this.relBuilder.minus(false, numInputs);
            }
            case MINUS_PRIMARY_ALL: 
            case MINUS_MULTISET: {
                return this.relBuilder.minus(true, numInputs);
            }
            case INTERSECTION_PRIMARY: 
            case INTERSECTION_MULTISET: {
                return this.relBuilder.intersect(false, numInputs);
            }
            case INTERSECTION_MULTISET_ALL: {
                return this.relBuilder.intersect(true, numInputs);
            }
            case UNION_DISTINCT: {
                return this.relBuilder.union(false, numInputs);
            }
            case UNION_ALL: {
                return this.relBuilder.union(true, numInputs);
            }
            case UNKNOWN: {
                throw new UnsupportedOperationException("Unknown set operation is not supported");
            }
        }
        throw new UnsupportedOperationException("Unsupported set operation: " + String.valueOf(set.getSetOp()));
    }

    public RelNode visit(Aggregate aggregate, Context context) throws RuntimeException {
        if (!PreCalciteAggregateValidator.isValidCalciteAggregate(aggregate)) {
            aggregate = PreCalciteAggregateValidator.PreCalciteAggregateTransformer.transformToValidCalciteAggregate(aggregate);
        }
        RelNode child = (RelNode)aggregate.getInput().accept((RelVisitor)this, (VisitationContext)context);
        List groupExprLists = aggregate.getGroupings().stream().map(gr -> gr.getExpressions().stream().map(expr -> (RexNode)expr.accept((ExpressionVisitor)this.expressionRexConverter, (VisitationContext)context)).collect(Collectors.toList())).collect(Collectors.toList());
        List groupExprs = groupExprLists.stream().flatMap(Collection::stream).collect(Collectors.toList());
        RelBuilder.GroupKey groupKey = this.relBuilder.groupKey(groupExprs, groupExprLists);
        List aggregateCalls = aggregate.getMeasures().stream().map(measure -> this.fromMeasure((Aggregate.Measure)measure, context)).collect(Collectors.toList());
        Optional<Rel.Remap> remap = aggregate.getRemap();
        int lastFieldIndex = groupExprs.size() + aggregateCalls.size();
        boolean emitDirect = remap.isEmpty();
        boolean groupingSetIndexGetsRemapped = remap.map(r -> r.indices().contains(lastFieldIndex)).orElse(false);
        if (aggregate.getGroupings().size() > 1 && (emitDirect || groupingSetIndexGetsRemapped)) {
            aggregateCalls.add(AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.GROUP_ID, (boolean)false, (boolean)false, (boolean)false, Collections.emptyList(), Collections.emptyList(), (int)-1, null, (RelCollation)RelCollations.EMPTY, (RelDataType)this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)TypeCreator.REQUIRED.I64), null));
            int groupingCallIndex = aggregateCalls.size() - 1;
            if (groupingSetIndexGetsRemapped) {
                LinkedList<Integer> remapList = new LinkedList<Integer>(((Rel.Remap)remap.get()).indices());
                for (int i = 0; i < remapList.size(); ++i) {
                    if (!((Integer)remapList.get(i)).equals(lastFieldIndex)) continue;
                    remapList.set(i, groupingCallIndex);
                }
                remap = Optional.of(Rel.Remap.of(remapList));
            }
        }
        RelNode node = this.relBuilder.push(child).aggregate(groupKey, aggregateCalls).build();
        return this.applyRemap(node, remap);
    }

    private AggregateCall fromMeasure(Aggregate.Measure measure, Context context) {
        List eArgs = measure.getFunction().arguments();
        List arguments = IntStream.range(0, measure.getFunction().arguments().size()).mapToObj(i -> (RexNode)((FunctionArg)eArgs.get(i)).accept((SimpleExtension.Function)measure.getFunction().declaration(), i, (FunctionArg.FuncArgVisitor)this.expressionRexConverter, (VisitationContext)context)).collect(Collectors.toList());
        Optional<SqlOperator> operator = this.aggregateFunctionConverter.getSqlOperatorFromSubstraitFunc(measure.getFunction().declaration().key(), measure.getFunction().outputType());
        if (!operator.isPresent()) {
            throw new IllegalArgumentException(String.format("Unable to find binding for call %s", measure.getFunction().declaration().name()));
        }
        ArrayList<Integer> argIndex = new ArrayList<Integer>();
        for (RexNode arg : arguments) {
            argIndex.add(((RexInputRef)arg).getIndex());
        }
        boolean distinct = measure.getFunction().invocation().equals((Object)Expression.AggregationInvocation.DISTINCT);
        RelDataType returnType = this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)measure.getFunction().getType());
        if (!(operator.get() instanceof SqlAggFunction)) {
            String msg = String.format("Unable to convert non-aggregate operator: %s for substrait aggregate function %s", operator.get(), measure.getFunction().declaration().name());
            throw new IllegalArgumentException(msg);
        }
        SqlAggFunction aggFunction = (SqlAggFunction)operator.get();
        int filterArg = -1;
        if (measure.getPreMeasureFilter().isPresent()) {
            RexNode filter = (RexNode)((Expression)measure.getPreMeasureFilter().get()).accept((ExpressionVisitor)this.expressionRexConverter, (VisitationContext)context);
            filterArg = ((RexInputRef)filter).getIndex();
        }
        RelCollation relCollation = RelCollations.EMPTY;
        if (!measure.getFunction().sort().isEmpty()) {
            relCollation = RelCollations.of(measure.getFunction().sort().stream().map(sortField -> this.toRelFieldCollation((Expression.SortField)sortField, context)).collect(Collectors.toList()));
        }
        return AggregateCall.create((SqlAggFunction)aggFunction, (boolean)distinct, (boolean)false, (boolean)false, Collections.emptyList(), argIndex, (int)filterArg, null, (RelCollation)relCollation, (RelDataType)returnType, null);
    }

    public RelNode visit(Sort sort, Context context) throws RuntimeException {
        RelNode child = (RelNode)sort.getInput().accept((RelVisitor)this, (VisitationContext)context);
        List sortExpressions = sort.getSortFields().stream().map(sortField -> this.directedRexNode((Expression.SortField)sortField, context)).collect(Collectors.toList());
        RelNode node = this.relBuilder.push(child).sort(sortExpressions).build();
        return this.applyRemap(node, sort.getRemap());
    }

    private RexNode directedRexNode(Expression.SortField sortField, Context context) {
        Expression expression = sortField.expr();
        RexNode rexNode = (RexNode)expression.accept((ExpressionVisitor)this.expressionRexConverter, (VisitationContext)context);
        Expression.SortDirection sortDirection = sortField.direction();
        if (sortDirection == Expression.SortDirection.ASC_NULLS_FIRST) {
            return this.relBuilder.nullsFirst(rexNode);
        }
        if (sortDirection == Expression.SortDirection.ASC_NULLS_LAST) {
            return this.relBuilder.nullsLast(rexNode);
        }
        if (sortDirection == Expression.SortDirection.DESC_NULLS_FIRST) {
            return this.relBuilder.nullsFirst(this.relBuilder.desc(rexNode));
        }
        if (sortDirection == Expression.SortDirection.DESC_NULLS_LAST) {
            return this.relBuilder.nullsLast(this.relBuilder.desc(rexNode));
        }
        if (sortDirection == Expression.SortDirection.CLUSTERED) {
            throw new UnsupportedOperationException(String.format("Unexpected Expression.SortDirection: Clustered!", new Object[0]));
        }
        throw new IllegalArgumentException("Unsupported sort direction: " + String.valueOf(sortDirection));
    }

    public RelNode visit(Fetch fetch, Context context) throws RuntimeException {
        RelNode child = (RelNode)fetch.getInput().accept((RelVisitor)this, (VisitationContext)context);
        OptionalLong optCount = fetch.getCount();
        long count = optCount.orElse(-1L);
        long offset = fetch.getOffset();
        if (offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("offset is overflowed as an integer: %d", offset));
        }
        if (count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("count is overflowed as an integer: %d", count));
        }
        RelNode node = this.relBuilder.push(child).limit((int)offset, (int)count).build();
        return this.applyRemap(node, fetch.getRemap());
    }

    private RelFieldCollation toRelFieldCollation(Expression.SortField sortField, Context context) {
        RelFieldCollation.NullDirection nullDirection;
        RelFieldCollation.Direction fieldDirection;
        Expression expression = sortField.expr();
        RexNode rex = (RexNode)expression.accept((ExpressionVisitor)this.expressionRexConverter, (VisitationContext)context);
        Expression.SortDirection sortDirection = sortField.direction();
        RexSlot rexSlot = (RexSlot)rex;
        int fieldIndex = rexSlot.getIndex();
        if (sortDirection == Expression.SortDirection.ASC_NULLS_FIRST) {
            fieldDirection = RelFieldCollation.Direction.ASCENDING;
            nullDirection = RelFieldCollation.NullDirection.FIRST;
        } else if (sortDirection == Expression.SortDirection.ASC_NULLS_LAST) {
            fieldDirection = RelFieldCollation.Direction.ASCENDING;
            nullDirection = RelFieldCollation.NullDirection.LAST;
        } else if (sortDirection == Expression.SortDirection.DESC_NULLS_FIRST) {
            nullDirection = RelFieldCollation.NullDirection.FIRST;
            fieldDirection = RelFieldCollation.Direction.DESCENDING;
        } else if (sortDirection == Expression.SortDirection.DESC_NULLS_LAST) {
            nullDirection = RelFieldCollation.NullDirection.LAST;
            fieldDirection = RelFieldCollation.Direction.DESCENDING;
        } else if (sortDirection == Expression.SortDirection.CLUSTERED) {
            fieldDirection = RelFieldCollation.Direction.CLUSTERED;
            nullDirection = RelFieldCollation.NullDirection.UNSPECIFIED;
        } else {
            throw new UnsupportedOperationException(String.format("Unexpected Expression.SortDirection enum: %s !", sortDirection));
        }
        return new RelFieldCollation(fieldIndex, fieldDirection, nullDirection);
    }

    public RelNode visit(NamedUpdate update, Context context) {
        this.relBuilder.scan((Iterable)update.getNames());
        RexNode condition = (RexNode)update.getCondition().accept((ExpressionVisitor)this.expressionRexConverter, (VisitationContext)context);
        this.relBuilder.filter(new RexNode[]{condition});
        RelNode inputForModify = this.relBuilder.build();
        NamedStruct tableSchema = update.getTableSchema();
        List fieldNames = tableSchema.names();
        ArrayList<String> updateColumnList = new ArrayList<String>();
        ArrayList<RexNode> sourceExpressionList = new ArrayList<RexNode>();
        for (AbstractUpdate.TransformExpression transform : update.getTransformations()) {
            updateColumnList.add((String)fieldNames.get(transform.getColumnTarget()));
            sourceExpressionList.add((RexNode)transform.getTransformation().accept((ExpressionVisitor)this.expressionRexConverter, (VisitationContext)context));
        }
        assert (this.relBuilder.getRelOptSchema() != null);
        RelOptTable table = this.relBuilder.getRelOptSchema().getTableForMember(update.getNames());
        if (table == null) {
            throw new IllegalStateException("Table not found in Calcite catalog: " + String.valueOf(update.getNames()));
        }
        Prepare.CatalogReader catalogReader = (Prepare.CatalogReader)table.getRelOptSchema();
        assert (catalogReader != null);
        return LogicalTableModify.create((RelOptTable)table, (Prepare.CatalogReader)catalogReader, (RelNode)inputForModify, (TableModify.Operation)TableModify.Operation.UPDATE, updateColumnList, sourceExpressionList, (boolean)false);
    }

    public RelNode visit(NamedDdl namedDdl, Context context) {
        if (namedDdl.getOperation() != AbstractDdlRel.DdlOp.CREATE || namedDdl.getObject() != AbstractDdlRel.DdlObject.VIEW) {
            throw new UnsupportedOperationException(String.format("Can only handle NamedDdl with (%s, %s), given (%s, %s)", AbstractDdlRel.DdlOp.CREATE, AbstractDdlRel.DdlObject.VIEW, namedDdl.getOperation(), namedDdl.getObject()));
        }
        if (namedDdl.getViewDefinition().isEmpty()) {
            throw new IllegalArgumentException("NamedDdl view definition must be set");
        }
        Rel viewDefinition = (Rel)namedDdl.getViewDefinition().get();
        RelNode relNode = (RelNode)viewDefinition.accept((RelVisitor)this, (VisitationContext)context);
        return new CreateView(namedDdl.getNames(), relNode);
    }

    public RelNode visit(VirtualTableScan virtualTableScan, Context context) {
        RelDataType typeInfoOnly = this.typeConverter.toCalcite(this.typeFactory, (TypeExpression)virtualTableScan.getInitialSchema().struct());
        List correctFieldNames = virtualTableScan.getInitialSchema().names();
        List fieldTypes = typeInfoOnly.getFieldList().stream().map(RelDataTypeField::getType).collect(Collectors.toList());
        RelDataType rowTypeWithNames = this.typeFactory.createStructType(fieldTypes, correctFieldNames);
        ArrayList<ImmutableList> tuples = new ArrayList<ImmutableList>();
        for (Expression.StructLiteral row : virtualTableScan.getRows()) {
            ArrayList<RexLiteral> rexRow = new ArrayList<RexLiteral>();
            for (Expression.Literal literal : row.fields()) {
                RexNode rexNode = (RexNode)literal.accept((ExpressionVisitor)this.expressionRexConverter, (VisitationContext)context);
                if (rexNode instanceof RexLiteral) {
                    RexLiteral rexLiteral = (RexLiteral)rexNode;
                    rexRow.add(rexLiteral);
                    continue;
                }
                throw new UnsupportedOperationException("VirtualTableScan only supports literal values, found: " + rexNode.getClass().getName());
            }
            tuples.add(ImmutableList.copyOf(rexRow));
        }
        return LogicalValues.create((RelOptCluster)this.relBuilder.getCluster(), (RelDataType)rowTypeWithNames, (ImmutableList)ImmutableList.copyOf(tuples));
    }

    private RelNode handleCreateTableAs(NamedWrite namedWrite, Context context) {
        if (namedWrite.getCreateMode() != AbstractWriteRel.CreateMode.REPLACE_IF_EXISTS || namedWrite.getOutputMode() != AbstractWriteRel.OutputMode.NO_OUTPUT) {
            throw new UnsupportedOperationException(String.format("Can only handle CTAS NamedWrite with (%s, %s), given (%s, %s)", AbstractWriteRel.CreateMode.REPLACE_IF_EXISTS, AbstractWriteRel.OutputMode.NO_OUTPUT, namedWrite.getCreateMode(), namedWrite.getOutputMode()));
        }
        Rel input = namedWrite.getInput();
        RelNode relNode = (RelNode)input.accept((RelVisitor)this, (VisitationContext)context);
        return new CreateTable(namedWrite.getNames(), relNode);
    }

    public RelNode visit(NamedWrite write, Context context) {
        TableModify.Operation operation;
        RelNode input = (RelNode)write.getInput().accept((RelVisitor)this, (VisitationContext)context);
        assert (this.relBuilder.getRelOptSchema() != null);
        RelOptTable targetTable = this.relBuilder.getRelOptSchema().getTableForMember(write.getNames());
        switch (write.getOperation()) {
            case INSERT: {
                operation = TableModify.Operation.INSERT;
                break;
            }
            case DELETE: {
                operation = TableModify.Operation.DELETE;
                break;
            }
            case CTAS: {
                return this.handleCreateTableAs(write, context);
            }
            default: {
                throw new UnsupportedOperationException(String.format("NamedWrite with WriteOp %s cannot be converted to a Calcite RelNode. Consider using a more specific Rel (e.g NamedUpdate)", write.getOperation()));
            }
        }
        assert (targetTable != null);
        return LogicalTableModify.create((RelOptTable)targetTable, (Prepare.CatalogReader)((Prepare.CatalogReader)this.relBuilder.getRelOptSchema()), (RelNode)input, (TableModify.Operation)operation, null, null, (boolean)false);
    }

    public RelNode visitFallback(Rel rel, Context context) throws RuntimeException {
        throw new UnsupportedOperationException(String.format("Rel %s of type %s not handled by visitor type %s.", rel, rel.getClass().getCanonicalName(), ((Object)((Object)this)).getClass().getCanonicalName()));
    }

    protected RelNode applyRemap(RelNode relNode, Optional<Rel.Remap> remap) {
        if (remap.isPresent()) {
            return this.applyRemap(relNode, remap.get());
        }
        return relNode;
    }

    private RelNode applyRemap(RelNode relNode, Rel.Remap remap) {
        RelDataType rowType = relNode.getRowType();
        List fieldNames = rowType.getFieldNames();
        List rexList = remap.indices().stream().map(index -> {
            RelDataTypeField t = rowType.getField((String)fieldNames.get((int)index), true, false);
            return new RexInputRef(index.intValue(), (RelDataType)t.getValue());
        }).collect(Collectors.toList());
        return this.relBuilder.push(relNode).project(rexList).build();
    }

    public RelBuilder getRelBuilder() {
        return this.relBuilder;
    }

    public static class Context
    implements VisitationContext {
        protected final Stack<RangeMap<Integer, RelDataType>> outerRowTypes = new Stack();
        protected final Stack<Set<CorrelationId>> correlationIds = new Stack();
        private int subqueryDepth;

        public static Context newContext() {
            return new Context();
        }

        public void pushOuterRowType(RelDataType ... inputs) {
            TreeRangeMap fieldRangeMap = TreeRangeMap.create();
            int begin = 0;
            for (RelDataType parent : inputs) {
                int end = begin + parent.getFieldCount();
                Range range = Range.closedOpen((Comparable)Integer.valueOf(begin), (Comparable)Integer.valueOf(end));
                fieldRangeMap.put(range, (Object)parent);
                begin = end;
            }
            this.outerRowTypes.push((RangeMap<Integer, RelDataType>)fieldRangeMap);
            this.correlationIds.push(new HashSet());
        }

        public void popOuterRowType() {
            this.outerRowTypes.pop();
        }

        public RangeMap<Integer, RelDataType> getOuterRowTypeRangeMap(Integer stepsOut) {
            return (RangeMap)this.outerRowTypes.get(this.subqueryDepth - stepsOut);
        }

        public Set<CorrelationId> popCorrelationIds() {
            return this.correlationIds.pop();
        }

        public void addCorrelationId(int stepsOut, CorrelationId correlationId) {
            int index = this.subqueryDepth - stepsOut;
            ((Set)this.correlationIds.get(index)).add(correlationId);
        }

        public void incrementSubqueryDepth() {
            ++this.subqueryDepth;
        }

        public void decrementSubqueryDepth() {
            --this.subqueryDepth;
        }
    }
}

