/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.expression;

import io.substrait.expression.Expression;
import io.substrait.expression.FunctionArg;
import io.substrait.extension.SimpleExtension;
import io.substrait.isthmus.expression.ScalarFunctionMapper;
import io.substrait.isthmus.expression.SubstraitFunctionMapping;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

final class SqrtFunctionMapper
implements ScalarFunctionMapper {
    private static final String sqrtFunctionName = "sqrt";
    private final List<SimpleExtension.ScalarFunctionVariant> sqrtFunctions;

    public SqrtFunctionMapper(List<SimpleExtension.ScalarFunctionVariant> functions) {
        this.sqrtFunctions = functions.stream().filter(f -> sqrtFunctionName.equalsIgnoreCase(f.name())).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public Optional<SubstraitFunctionMapping> toSubstrait(RexCall call) {
        if (this.sqrtFunctions.isEmpty()) {
            return Optional.empty();
        }
        if (SqrtFunctionMapper.isPowerOfHalf(call)) {
            List<RexNode> operands = call.getOperands().subList(0, 1);
            return Optional.of(new SubstraitFunctionMapping(sqrtFunctionName, operands, this.sqrtFunctions));
        }
        return Optional.empty();
    }

    private static boolean isPowerOfHalf(RexCall call) {
        if (!SqlStdOperatorTable.POWER.equals((Object)call.getOperator()) || call.getOperands().size() != 2) {
            return false;
        }
        RexNode exponent = (RexNode)call.getOperands().get(1);
        while (exponent.getKind() == SqlKind.CAST) {
            exponent = (RexNode)((RexCall)exponent).getOperands().get(0);
        }
        if (!(exponent instanceof RexLiteral)) {
            return false;
        }
        RexLiteral literal = (RexLiteral)exponent;
        switch (literal.getType().getSqlTypeName()) {
            case DOUBLE: 
            case FLOAT: 
            case REAL: {
                Double digit = (Double)literal.getValueAs(Double.class);
                return digit != null && Math.abs(digit - 0.5) < 1.0E-15;
            }
            case DECIMAL: {
                BigDecimal bigdec = (BigDecimal)literal.getValueAs(BigDecimal.class);
                return bigdec != null && BigDecimal.valueOf(5L, 1).compareTo(bigdec) == 0;
            }
        }
        return false;
    }

    @Override
    public Optional<List<FunctionArg>> getExpressionArguments(Expression.ScalarFunctionInvocation expression) {
        return Optional.empty();
    }
}

