/*
 * Decompiled with CFR 0.152.
 */
package io.substrait.isthmus.sql;

import com.google.common.collect.ImmutableList;
import io.substrait.isthmus.SqlConverterBase;
import io.substrait.isthmus.SubstraitTypeSystem;
import io.substrait.isthmus.Utils;
import io.substrait.isthmus.calcite.SubstraitTable;
import io.substrait.isthmus.sql.SubstraitSqlStatementParser;
import io.substrait.isthmus.sql.SubstraitSqlValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlCreateTable;
import org.apache.calcite.sql.ddl.SqlKeyConstraint;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SubstraitCreateStatementParser {
    public static final CalciteCatalogReader EMPTY_CATALOG = new CalciteCatalogReader(CalciteSchema.createRootSchema((boolean)false), List.of(), SubstraitTypeSystem.TYPE_FACTORY, SqlConverterBase.CONNECTION_CONFIG);
    public static final SqlValidator VALIDATOR = new SubstraitSqlValidator((Prepare.CatalogReader)EMPTY_CATALOG);

    public static List<SubstraitTable> processCreateStatements(@NonNull String createStatements) throws SqlParseException {
        ArrayList<SubstraitTable> tableList = new ArrayList<SubstraitTable>();
        List<SqlNode> sqlNode = SubstraitSqlStatementParser.parseStatements(createStatements);
        for (SqlNode parsed : sqlNode) {
            if (!(parsed instanceof SqlCreateTable)) {
                throw SubstraitCreateStatementParser.fail("Not a valid CREATE TABLE statement.");
            }
            SqlCreateTable create = (SqlCreateTable)parsed;
            if (create.name.names.size() > 1) {
                throw SubstraitCreateStatementParser.fail("Only simple table names are allowed.", create.name.getParserPosition());
            }
            if (create.query != null) {
                throw SubstraitCreateStatementParser.fail("CTAS not supported.", create.name.getParserPosition());
            }
            tableList.add(SubstraitCreateStatementParser.createSubstraitTable((String)create.name.names.get(0), create.columnList));
        }
        return tableList;
    }

    public static CalciteCatalogReader processCreateStatementsToCatalog(String ... createStatements) throws SqlParseException {
        CalciteSchema rootSchema = SubstraitCreateStatementParser.processCreateStatementsToSchema(createStatements);
        List defaultSchema = Collections.emptyList();
        return new CalciteCatalogReader(rootSchema, defaultSchema, SubstraitTypeSystem.TYPE_FACTORY, SqlConverterBase.CONNECTION_CONFIG);
    }

    private static SqlParseException fail(@Nullable String message, @Nullable SqlParserPos pos) {
        return new SqlParseException(message, pos, null, null, (Throwable)new RuntimeException("fake lineage"));
    }

    private static SqlParseException fail(@Nullable String message) {
        return SubstraitCreateStatementParser.fail(message, SqlParserPos.ZERO);
    }

    private static CalciteSchema processCreateStatementsToSchema(String ... createStatements) throws SqlParseException {
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)false);
        for (String statement : createStatements) {
            List<SqlNode> sqlNode = SubstraitSqlStatementParser.parseStatements(statement);
            for (SqlNode parsed : sqlNode) {
                String tableName;
                if (!(parsed instanceof SqlCreateTable)) {
                    throw SubstraitCreateStatementParser.fail("Not a valid CREATE TABLE statement.");
                }
                SqlCreateTable create = (SqlCreateTable)parsed;
                ImmutableList names = create.name.names;
                CalciteSchema schema = Utils.createCalciteSchemaFromNames(rootSchema, names.subList(0, names.size() - 1));
                CalciteSchema.TableEntry table = schema.getTable(tableName = (String)names.get(names.size() - 1), false);
                if (table == null) {
                    schema.add(tableName, (Table)SubstraitCreateStatementParser.createSubstraitTable(tableName, create.columnList));
                    continue;
                }
                throw SubstraitCreateStatementParser.fail("Table must not be defined more than once", parsed.getParserPosition());
            }
        }
        return rootSchema;
    }

    private static SubstraitTable createSubstraitTable(@NonNull String tableName, @NonNull SqlNodeList columnList) throws SqlParseException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<RelDataType> columnTypes = new ArrayList<RelDataType>();
        for (SqlNode node : columnList) {
            if (!(node instanceof SqlColumnDeclaration)) {
                if (node instanceof SqlKeyConstraint) continue;
                throw SubstraitCreateStatementParser.fail("Unexpected column list construction.", node.getParserPosition());
            }
            SqlColumnDeclaration col = (SqlColumnDeclaration)node;
            if (col.name.names.size() != 1) {
                throw SubstraitCreateStatementParser.fail("Expected simple column names.", col.name.getParserPosition());
            }
            names.add((String)col.name.names.get(0));
            columnTypes.add(col.dataType.deriveType(VALIDATOR));
        }
        return new SubstraitTable(tableName, SubstraitTypeSystem.TYPE_FACTORY.createStructType(columnTypes, names));
    }
}

