/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.functions.overrides;

import io.sundr.Function;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.codegen.converters.StringToJavaType;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import java.util.HashMap;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToBuildableJavaType
implements Function<String, JavaType> {
    private static final String BUILDABLE = "BUILDABLE";
    private final Elements elements;
    private final Function<String, JavaType> delegate;

    public ToBuildableJavaType(Elements elements) {
        this.elements = elements;
        this.delegate = new StringToJavaType(elements);
    }

    public JavaType apply(String fullName) {
        JavaType type = (JavaType)this.delegate.apply((Object)fullName);
        if (type == null) {
            return null;
        }
        TypeElement typeElement = this.elements.getTypeElement(fullName);
        boolean isBuildable = false;
        if (fullName.endsWith("[]")) {
            typeElement = this.elements.getTypeElement(fullName.substring(0, fullName.length() - 2));
            isBuildable = this.isBuildable(typeElement);
        } else if (type.isCollection()) {
            for (JavaType genericType : type.getGenericTypes()) {
                isBuildable = this.isBuildable(this.elements.getTypeElement(genericType.getFullyQualifiedName()));
            }
        } else {
            isBuildable = this.isBuildable(typeElement);
        }
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>(type.getAttributes());
        attributes.put(BUILDABLE, isBuildable);
        return ((JavaTypeBuilder)new JavaTypeBuilder(type).withAttributes(attributes)).build();
    }

    private boolean isBuildable(TypeElement typeElement) {
        if (typeElement != null) {
            if (typeElement.getAnnotation(Buildable.class) != null) {
                return true;
            }
            for (Element element : typeElement.getEnclosedElements()) {
                if (element.getAnnotation(Buildable.class) == null) continue;
                return true;
            }
        }
        return BuilderContextManager.getContext().getRepository().isBuildable(typeElement);
    }
}

