/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.visitors;

import io.sundr.Function;
import io.sundr.builder.Constants;
import io.sundr.builder.TypedVisitor;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.functions.Collections;
import io.sundr.codegen.functions.Optionals;
import io.sundr.codegen.model.Attributeable;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.EditableClassRef;
import io.sundr.codegen.model.Kind;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.PropertyBuilder;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.TypeUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class InitEnricher
extends TypedVisitor<PropertyBuilder> {
    public void visit(PropertyBuilder builder) {
        TypeRef typeRef = builder.buildTypeRef();
        TypeRef unwrapped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_ARRAY_OF, TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_OPTIONAL_OF).apply((Object)typeRef);
        boolean isBuildable = BuilderUtils.isBuildable(unwrapped);
        boolean hasDescendants = false;
        if (!(typeRef instanceof ClassRef)) {
            return;
        }
        Property parent = (Property)builder.getAttributes().get(Constants.DESCENDANT_OF);
        if (parent != null) {
            typeRef = parent.getTypeRef();
            unwrapped = (TypeRef)TypeAs.combine(TypeAs.UNWRAP_ARRAY_OF, TypeAs.UNWRAP_COLLECTION_OF, TypeAs.UNWRAP_OPTIONAL_OF).apply((Object)typeRef);
        } else if (builder.getAttributes().containsKey(Constants.DESCENDANTS) && !((Collection)builder.getAttributes().get(Constants.DESCENDANTS)).isEmpty()) {
            hasDescendants = true;
        }
        List arguments = ((ClassRef)typeRef).getArguments();
        TypeRef targetType = unwrapped;
        if (isBuildable || hasDescendants) {
            ClassRef unwarppedClassRef = unwrapped instanceof ClassRef ? (ClassRef)unwrapped : null;
            targetType = TypeUtils.isAbstract((TypeRef)unwarppedClassRef) || unwarppedClassRef.getDefinition().getKind() == Kind.INTERFACE ? (TypeRef)TypeAs.VISITABLE_BUILDER.apply((Object)unwarppedClassRef) : ((TypeDef)TypeAs.BUILDER.apply((Object)unwarppedClassRef.getDefinition())).toInternalReference();
        }
        boolean isArray = TypeUtils.isArray((TypeRef)typeRef);
        boolean isSet = TypeUtils.isSet((TypeRef)typeRef);
        boolean isList = TypeUtils.isList((TypeRef)typeRef);
        boolean isMap = TypeUtils.isMap((TypeRef)typeRef);
        boolean isOptional = TypeUtils.isOptional((TypeRef)typeRef);
        boolean isOptionalInt = TypeUtils.isOptionalInt((TypeRef)typeRef);
        boolean isOptionalDouble = TypeUtils.isOptionalDouble((TypeRef)typeRef);
        boolean isOptionalLong = TypeUtils.isOptionalLong((TypeRef)typeRef);
        if (isArray || isList) {
            ClassRef listRef = Collections.ARRAY_LIST.toReference(new TypeRef[]{targetType});
            ((PropertyBuilder)builder.addToAttributes(Attributeable.LAZY_INIT, (Object)("new " + listRef + "()"))).addToAttributes(Attributeable.ALSO_IMPORT, Arrays.asList(targetType, listRef));
        } else if (isSet) {
            ClassRef setRef = Collections.LINKED_HASH_SET.toReference(new TypeRef[]{unwrapped});
            ((PropertyBuilder)builder.addToAttributes(Attributeable.LAZY_INIT, (Object)("new " + setRef + "()"))).addToAttributes(Attributeable.ALSO_IMPORT, Arrays.asList(targetType, setRef));
        } else if (isMap) {
            ClassRef mapRef = Collections.LINKED_HASH_MAP.toReference(arguments);
            ((PropertyBuilder)builder.addToAttributes(Attributeable.LAZY_INIT, (Object)("new " + mapRef + "()"))).addToAttributes(Attributeable.ALSO_IMPORT, Arrays.asList(targetType, mapRef));
        } else if (isOptional) {
            EditableClassRef ref = ((ClassRefBuilder)new ClassRefBuilder(Optionals.OPTIONAL.toReference(new TypeRef[0])).withArguments(java.util.Collections.EMPTY_LIST)).build();
            ((PropertyBuilder)((PropertyBuilder)builder.addToAttributes(Attributeable.INIT, (Object)"Optional.empty()")).addToAttributes(Attributeable.INIT_FUNCTION, (Object)new Function<List<String>, String>((ClassRef)ref){
                final /* synthetic */ ClassRef val$ref;
                {
                    this.val$ref = classRef;
                }

                public String apply(List<String> arguments) {
                    if (arguments.size() != 1) {
                        throw new IllegalArgumentException("Optional initializer only accepts one argument");
                    }
                    return this.val$ref + ".of(" + arguments.get(0) + ")";
                }
            })).addToAttributes(Attributeable.ALSO_IMPORT, Arrays.asList(targetType, ref));
        } else if (isOptionalDouble) {
            final ClassRef ref = Optionals.OPTIONAL_DOUBLE.toReference(new TypeRef[0]);
            ((PropertyBuilder)((PropertyBuilder)builder.addToAttributes(Attributeable.INIT, (Object)"OptionalDouble.empty()")).addToAttributes(Attributeable.INIT_FUNCTION, (Object)new Function<List<String>, String>(){

                public String apply(List<String> arguments) {
                    if (arguments.size() != 1) {
                        throw new IllegalArgumentException("Optional initializer only accepts one argument");
                    }
                    return ref + ".of(" + arguments.get(0) + ")";
                }
            })).addToAttributes(Attributeable.ALSO_IMPORT, Arrays.asList(targetType, ref));
        } else if (isOptionalInt) {
            final ClassRef ref = Optionals.OPTIONAL_INT.toReference(new TypeRef[0]);
            ((PropertyBuilder)((PropertyBuilder)builder.addToAttributes(Attributeable.INIT, (Object)"OptionalInt.empty()")).addToAttributes(Attributeable.INIT_FUNCTION, (Object)new Function<List<String>, String>(){

                public String apply(List<String> arguments) {
                    if (arguments.size() != 1) {
                        throw new IllegalArgumentException("Optional initializer only accepts one argument");
                    }
                    return ref + ".of(" + arguments.get(0) + ")";
                }
            })).addToAttributes(Attributeable.ALSO_IMPORT, Arrays.asList(targetType, ref));
        } else if (isOptionalLong) {
            final ClassRef ref = Optionals.OPTIONAL_LONG.toReference(new TypeRef[0]);
            ((PropertyBuilder)((PropertyBuilder)builder.addToAttributes(Attributeable.INIT, (Object)"OptionalLong.empty()")).addToAttributes(Attributeable.INIT_FUNCTION, (Object)new Function<List<String>, String>(){

                public String apply(List<String> arguments) {
                    if (arguments.size() != 1) {
                        throw new IllegalArgumentException("Optional initializer only accepts one argument");
                    }
                    return ref + ".of(" + arguments.get(0) + ")";
                }
            })).addToAttributes(Attributeable.ALSO_IMPORT, Arrays.asList(targetType, ref));
        }
    }
}

