/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.resourcecify.internal.processor;

import com.sun.tools.javac.code.Symbol;
import io.sundr.resourcecify.annotations.Resourcecify;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"io.sundr.resourcecify.annotations.Resourcecify"})
public class ResourcecifyProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        Filer filer = this.processingEnv.getFiler();
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                Resourcecify resourcecify = element.getAnnotation(Resourcecify.class);
                if (resourcecify == null || !(element instanceof Symbol.ClassSymbol)) continue;
                Symbol.ClassSymbol s = (Symbol.ClassSymbol)element;
                try {
                    String packageName = ResourcecifyProcessor.getPackageName(s);
                    JavaFileObject source = s.sourcefile;
                    File sourceFile = new File(source.getName()).getAbsoluteFile();
                    String sourceFileName = sourceFile.getName();
                    FileObject target = filer.createResource(StandardLocation.CLASS_OUTPUT, packageName, sourceFileName, s);
                    ResourcecifyProcessor.copy(source, target);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static String getPackageName(Element element) {
        return ResourcecifyProcessor.getPackageElement(element).getQualifiedName().toString();
    }

    public static PackageElement getPackageElement(Element element) {
        if (element instanceof PackageElement) {
            return (PackageElement)element;
        }
        return ResourcecifyProcessor.getPackageElement(element.getEnclosingElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(FileObject source, FileObject target) throws IOException {
        InputStream in = source.openInputStream();
        OutputStream out = target.openOutputStream();
        try {
            byte[] buffer = new byte[1024];
            int len = in.read(buffer);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }
}

