/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.api;

import io.sundr.adapter.api.Adapter;
import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.api.AdapterFactory;
import io.sundr.model.TypeDef;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public class Adapters {
    public static <C extends AdapterContext, T, R, P, M> TypeDef adapt(T input, C ctx) {
        if (input == null) {
            throw new IllegalArgumentException("Adapter.adapt(null) is now allowed!");
        }
        return Adapters.getAdapter(ctx).map(a -> a.adaptType(input)).orElseThrow(() -> new IllegalStateException("No adapter found for: " + ctx.getClass()));
    }

    public static <C extends AdapterContext, T, R, P, M> Optional<Adapter<T, R, P, M>> getAdapter(C ctx) {
        Class<?> contextType = ctx.getClass();
        return StreamSupport.stream(ServiceLoader.load(AdapterFactory.class, ctx.getClass().getClassLoader()).spliterator(), false).filter(f -> f.getContextType().isAssignableFrom(contextType)).map(f -> f.create(ctx)).findFirst();
    }

    public static WithContext withContext(AdapterContext ctx) {
        return new WithContext(ctx);
    }

    public static class WithContext {
        private final AdapterContext ctx;

        public WithContext(AdapterContext ctx) {
            this.ctx = ctx;
        }

        public <T> TypeDef adapt(T input) {
            return Adapters.adapt(input, this.ctx);
        }
    }
}

