/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.apt;

import io.sundr.adapter.apt.AptContext;
import io.sundr.adapter.apt.visitors.TypeRefTypeVisitor;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AnnotationRefBuilder;
import io.sundr.model.ClassRef;
import io.sundr.model.TypeRef;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public class AnnotationMirrorToAnnotationRef
implements Function<AnnotationMirror, AnnotationRef> {
    private static final String EMPTY_PARENTHESIS = "()";
    private static final String EMPTY = "";
    private final AptContext context;

    public AnnotationMirrorToAnnotationRef(AptContext context) {
        this.context = context;
    }

    @Override
    public AnnotationRef apply(AnnotationMirror item) {
        TypeRef annotationType = item.getAnnotationType().accept(new TypeRefTypeVisitor(this.context), 0);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (annotationType instanceof ClassRef) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : item.getElementValues().entrySet()) {
                String key = entry.getKey().toString().replace(EMPTY_PARENTHESIS, EMPTY);
                Object value = this.mapAnnotationValue(entry.getValue().getValue());
                parameters.put(key, value);
            }
            return ((AnnotationRefBuilder)((AnnotationRefBuilder)new AnnotationRefBuilder().withClassRef((ClassRef)annotationType)).withParameters(parameters)).build();
        }
        throw new IllegalStateException("Annotation type: [" + annotationType + "] is not a class reference.");
    }

    private Object mapAnnotationValue(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(this::mapAnnotationValue).collect(Collectors.toList());
        }
        if (value instanceof AnnotationMirror) {
            return this.apply((AnnotationMirror)value);
        }
        if (value instanceof AnnotationValue) {
            return ((AnnotationValue)value).getValue();
        }
        if (value instanceof TypeMirror) {
            return this.context.getTypeMirrorToTypeRef().apply((TypeMirror)value);
        }
        return value;
    }
}

