/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.apt;

import io.sundr.adapter.apt.AptContext;
import io.sundr.model.AnnotationRef;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.utils.Types;
import io.sundr.utils.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;

public class VariableElementToProperty
implements Function<VariableElement, Property> {
    private static final String NEWLINE_PATTERN = "\r|\n";
    private final AptContext context;

    public VariableElementToProperty(AptContext context) {
        this.context = context;
    }

    @Override
    public Property apply(VariableElement variableElement) {
        String name = variableElement.getSimpleName().toString();
        TypeRef type = this.context.getTypeMirrorToTypeRef().apply(variableElement.asType());
        ArrayList<AnnotationRef> annotations = new ArrayList<AnnotationRef>();
        for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
            annotations.add(this.context.getAnnotationMirrorToAnnotationRef().apply(annotationMirror));
        }
        String comments = this.context.getElements().getDocComment(variableElement);
        ArrayList arrayList = Strings.isNullOrEmpty((String)comments) ? new ArrayList() : Arrays.stream(comments.split(NEWLINE_PATTERN)).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        return ((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)((PropertyBuilder)new PropertyBuilder().withComments(arrayList)).withName(name)).withTypeRef(type)).withAnnotations(annotations)).withModifiers(Types.modifiersToInt(variableElement.getModifiers()))).build();
    }
}

