/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.apt.visitors;

import io.sundr.adapter.apt.AptContext;
import io.sundr.model.Kind;
import io.sundr.model.Method;
import io.sundr.model.Property;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeParamDef;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;

public class TypeDefElementVisitor
implements ElementVisitor<TypeDefBuilder, Void> {
    private final TypeDefBuilder builder = new TypeDefBuilder();
    private final AptContext context;

    public TypeDefElementVisitor(AptContext context) {
        this.context = context;
    }

    @Override
    public TypeDefBuilder visit(Element e, Void aVoid) {
        return (TypeDefBuilder)this.builder.withName(e.getSimpleName().toString());
    }

    @Override
    public TypeDefBuilder visit(Element e) {
        if (e instanceof TypeElement) {
            return new TypeDefBuilder(this.context.getDefinitionRepository().register(new TypeDefBuilder(this.context.getTypeElementToTypeDef().apply((TypeElement)e)).build()));
        }
        String name = e.getSimpleName().toString();
        this.builder.withName(name);
        if (e.getKind() == ElementKind.INTERFACE) {
            this.builder.withKind(Kind.INTERFACE);
        } else if (e.getKind() == ElementKind.ENUM) {
            this.builder.withKind(Kind.ENUM);
        } else if (e.getKind() == ElementKind.ANNOTATION_TYPE) {
            this.builder.withKind(Kind.ANNOTATION);
        } else {
            this.builder.withKind(Kind.CLASS);
        }
        if (e.getEnclosingElement() instanceof PackageElement) {
            String packageName = e.getEnclosingElement().toString();
            this.builder.withPackageName(packageName);
        }
        return this.builder;
    }

    @Override
    public TypeDefBuilder visitPackage(PackageElement e, Void aVoid) {
        return (TypeDefBuilder)this.builder.withPackageName(e.getQualifiedName().toString());
    }

    @Override
    public TypeDefBuilder visitType(TypeElement e, Void aVoid) {
        return (TypeDefBuilder)this.builder.withName(e.getSimpleName().toString());
    }

    @Override
    public TypeDefBuilder visitVariable(VariableElement e, Void aVoid) {
        return (TypeDefBuilder)this.builder.addToProperties(new Property[]{this.context.getVariableElementToProperty().apply(e)});
    }

    @Override
    public TypeDefBuilder visitExecutable(ExecutableElement e, Void aVoid) {
        return (TypeDefBuilder)this.builder.addToMethods(new Method[]{this.context.getExecutableElementToMethod().apply(e)});
    }

    @Override
    public TypeDefBuilder visitTypeParameter(TypeParameterElement e, Void aVoid) {
        return (TypeDefBuilder)this.builder.addToParameters(new TypeParamDef[]{this.context.getTypeParamElementToTypeParamDef().apply(e)});
    }

    @Override
    public TypeDefBuilder visitUnknown(Element e, Void aVoid) {
        return this.builder;
    }
}

