/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.apt;

import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.api.AdapterContextAware;
import io.sundr.model.AttributeKey;
import io.sundr.model.AttributeSupport;
import io.sundr.model.repo.DefinitionRepository;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class AptContext
extends AttributeSupport
implements AdapterContextAware {
    private static final AttributeKey<Types> TYPES_KEY = new AttributeKey(Types.class);
    private static final AttributeKey<Elements> ELEMENTS_KEY = new AttributeKey(Elements.class);
    private static AptContext INSTANCE;
    private final AdapterContext adapterContext;
    private final Set<TypeElement> references = new HashSet<TypeElement>();

    private AptContext(Elements elements, Types types, DefinitionRepository repository) {
        super(AptContext.createAttributes(elements, types));
        this.adapterContext = AdapterContext.create((DefinitionRepository)repository, (Map)this.getAttributes());
    }

    private static Map<AttributeKey, Object> createAttributes(Elements elements, Types types) {
        HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>();
        attributes.put(ELEMENTS_KEY, elements);
        attributes.put(TYPES_KEY, types);
        return attributes;
    }

    public static synchronized AptContext create(AdapterContext adapterContext) {
        Types types = (Types)adapterContext.getAttribute(TYPES_KEY);
        Elements elements = (Elements)adapterContext.getAttribute(ELEMENTS_KEY);
        if (elements == null) {
            Elements elements2 = elements = INSTANCE != null ? (Elements)INSTANCE.getAttribute(ELEMENTS_KEY) : null;
            if (elements == null) {
                throw new IllegalStateException("AptContext requires javax.lang.model.util.Elements utilitiy.");
            }
        }
        if (types == null) {
            Types types2 = types = INSTANCE != null ? (Types)INSTANCE.getAttribute(TYPES_KEY) : null;
            if (types == null) {
                throw new IllegalStateException("AptContext requires javax.lang.model.util.Types utilitiy.");
            }
        }
        INSTANCE = new AptContext(elements, types, adapterContext.getDefinitionRepository());
        return INSTANCE;
    }

    public static synchronized AptContext create(Elements elements, Types types) {
        INSTANCE = new AptContext(elements, types, DefinitionRepository.createRepository());
        return INSTANCE;
    }

    public static synchronized AptContext create(Elements elements, Types types, DefinitionRepository repository) {
        INSTANCE = new AptContext(elements, types, repository);
        return INSTANCE;
    }

    public static synchronized AptContext getContext() {
        if (INSTANCE == null) {
            throw new IllegalStateException("AptContext has not been created, yet.");
        }
        return INSTANCE;
    }

    public Types getTypes() {
        return (Types)this.getAttribute(TYPES_KEY);
    }

    public Elements getElements() {
        return (Elements)this.getAttribute(ELEMENTS_KEY);
    }

    public boolean isDeep() {
        return true;
    }

    public AdapterContext getAdapterContext() {
        return this.adapterContext;
    }

    public DefinitionRepository getDefinitionRepository() {
        return this.adapterContext.getDefinitionRepository();
    }

    public Set<TypeElement> getReferences() {
        return this.references;
    }
}

