/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.apt.visitors;

import io.sundr.adapter.apt.AptContext;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.VoidRefBuilder;
import java.util.ArrayList;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor6;

public class TypeRefTypeVisitor
extends AbstractTypeVisitor6<TypeRef, Integer> {
    private final AptContext context;

    public TypeRefTypeVisitor(AptContext context) {
        this.context = context;
    }

    @Override
    public TypeRef visitPrimitive(PrimitiveType t, Integer dimension) {
        return ((PrimitiveRefBuilder)((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName(t.getKind().name().toLowerCase())).withDimensions(dimension.intValue())).build();
    }

    @Override
    public TypeRef visitNull(NullType t, Integer dimension) {
        return null;
    }

    @Override
    public TypeRef visitArray(ArrayType t, Integer dimension) {
        return t.getComponentType().accept(this, dimension + 1);
    }

    @Override
    public TypeRef visitDeclared(DeclaredType t, Integer dimension) {
        ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
        for (TypeMirror typeMirror : t.getTypeArguments()) {
            TypeRef arg = typeMirror.accept(this, dimension);
            if (arg == null) continue;
            arguments.add(arg);
        }
        TypeElement element = (TypeElement)t.asElement();
        if (!this.context.getDefinitionRepository().hasDefinition(element.toString())) {
            this.context.getReferences().add(element);
        }
        String string = element.toString();
        return ((ClassRefBuilder)((ClassRefBuilder)((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(string)).withDimensions(dimension.intValue())).withArguments(arguments)).build();
    }

    @Override
    public TypeRef visitError(ErrorType t, Integer dimension) {
        TypeElement element = (TypeElement)t.asElement();
        String fqcn = element.toString();
        return ((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(fqcn)).build();
    }

    @Override
    public TypeRef visitTypeVariable(TypeVariable t, Integer dimension) {
        return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(t.asElement().getSimpleName().toString())).build();
    }

    @Override
    public TypeRef visitWildcard(WildcardType t, Integer dimension) {
        return null;
    }

    @Override
    public TypeRef visitExecutable(ExecutableType t, Integer dimension) {
        return null;
    }

    @Override
    public TypeRef visitNoType(NoType t, Integer dimension) {
        return new VoidRefBuilder().build();
    }

    @Override
    public TypeRef visitUnknown(TypeMirror t, Integer dimension) {
        return null;
    }
}

