/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.apt;

import io.sundr.adapter.api.Adapter;
import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.apt.AnnotationMirrorToAnnotationRef;
import io.sundr.adapter.apt.AptContext;
import io.sundr.adapter.apt.ExecutableElementToMethod;
import io.sundr.adapter.apt.TypeElementToTypeDef;
import io.sundr.adapter.apt.TypeMirrorToTypeRef;
import io.sundr.adapter.apt.TypePrameterElementToTypeParamDef;
import io.sundr.adapter.apt.VariableElementToProperty;
import io.sundr.model.AnnotationRef;
import io.sundr.model.Method;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeRef;
import java.util.function.Function;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class AptAdapter
implements Adapter<TypeElement, TypeMirror, VariableElement, ExecutableElement> {
    private final AptContext context;
    private final Function<TypeElement, TypeDef> typeAdapterFunction;
    private final Function<TypeMirror, TypeRef> referenceAdapterFunction;
    private final Function<VariableElement, Property> propertyAdapterFunction;
    private final Function<ExecutableElement, Method> methodAdapterFunction;
    private final Function<AnnotationMirror, AnnotationRef> annotationAdapterFunction;
    private final Function<TypeParameterElement, TypeParamDef> typeParamAdapterFunction;

    public AptAdapter(AdapterContext context) {
        this.context = AptContext.create(context);
        this.referenceAdapterFunction = new TypeMirrorToTypeRef(this.context);
        this.annotationAdapterFunction = new AnnotationMirrorToAnnotationRef(this.context, this.referenceAdapterFunction);
        this.typeParamAdapterFunction = new TypePrameterElementToTypeParamDef(this.context, this.referenceAdapterFunction);
        this.propertyAdapterFunction = new VariableElementToProperty(this.context, this.referenceAdapterFunction, this.annotationAdapterFunction);
        this.methodAdapterFunction = new ExecutableElementToMethod(this.context, this.referenceAdapterFunction, this.propertyAdapterFunction, this.annotationAdapterFunction);
        this.typeAdapterFunction = new TypeElementToTypeDef(this.context, this.referenceAdapterFunction, this.propertyAdapterFunction, this.methodAdapterFunction, this.annotationAdapterFunction, this.typeParamAdapterFunction);
    }

    public Function<TypeElement, TypeDef> getTypeAdapterFunction() {
        return this.typeAdapterFunction;
    }

    public Function<TypeMirror, TypeRef> getReferenceAdapterFunction() {
        return this.referenceAdapterFunction;
    }

    public Function<VariableElement, Property> getPropertyAdapterFunction() {
        return this.propertyAdapterFunction;
    }

    public Function<ExecutableElement, Method> getMethodAdapterFunction() {
        return this.methodAdapterFunction;
    }
}

