/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.apt;

import io.sundr.SundrException;
import io.sundr.adapter.apt.AptContext;
import io.sundr.adapter.apt.utils.Apt;
import io.sundr.model.AnnotationRef;
import io.sundr.model.ClassRef;
import io.sundr.model.Kind;
import io.sundr.model.Method;
import io.sundr.model.Modifiers;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeRef;
import io.sundr.utils.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class TypeElementToTypeDef
implements Function<TypeElement, TypeDef> {
    private static final String OBJECT_BOUND = "java.lang.Object";
    private static final String JAVA_PEFIX = "java.";
    private static final String JAVAX_PEFIX = "javax.";
    private static final String COM_SUN_PREFIX = "com.sun.";
    private static final String EMPTY_PARENTHESIS = "()";
    private static final String EMPTY = "";
    private static final String NEWLINE_PATTERN = "\r|\n";
    private static final String ANY = "<any?>";
    private final AptContext context;
    private final Function<TypeMirror, TypeRef> referenceAdapterFunction;
    private final Function<VariableElement, Property> propertyAdapterFunction;
    private final Function<ExecutableElement, Method> methodAdapterFunction;
    private final Function<AnnotationMirror, AnnotationRef> annotationAdapterFunction;
    private final Function<TypeParameterElement, TypeParamDef> typeParamAdapterFunction;

    public TypeElementToTypeDef(AptContext context, Function<TypeMirror, TypeRef> referenceAdapterFunction, Function<VariableElement, Property> propertyAdapterFunction, Function<ExecutableElement, Method> methodAdapterFunction, Function<AnnotationMirror, AnnotationRef> annotationAdapterFunction, Function<TypeParameterElement, TypeParamDef> typeParamAdapterFunction) {
        this.context = context;
        this.referenceAdapterFunction = referenceAdapterFunction;
        this.propertyAdapterFunction = propertyAdapterFunction;
        this.methodAdapterFunction = methodAdapterFunction;
        this.annotationAdapterFunction = annotationAdapterFunction;
        this.typeParamAdapterFunction = typeParamAdapterFunction;
    }

    @Override
    public TypeDef apply(TypeElement classElement) {
        Kind kind = Kind.CLASS;
        Element enclosing = classElement.getEnclosingElement();
        if (enclosing != null && ANY.equals(enclosing.getSimpleName().toString())) {
            throw new SundrException("Failed to read class element:" + classElement.getQualifiedName().toString() + ". " + "This may be caused due to the compiler not being able to resolve a symbol. Please check for unresolved symbols!");
        }
        TypeMirror superClass = classElement.getSuperclass();
        ClassRef superClassType = TypeDef.OBJECT_REF;
        if (superClass != null && !(superClass instanceof NoType) && !superClass.toString().equals(TypeDef.OBJECT.getFullyQualifiedName())) {
            superClassType = this.referenceAdapterFunction.apply(superClass);
        }
        ArrayList<TypeParamDef> genericTypes = new ArrayList<TypeParamDef>();
        ArrayList<ClassRef> interfaces = new ArrayList<ClassRef>();
        if (classElement.getKind() == ElementKind.INTERFACE) {
            kind = Kind.INTERFACE;
        } else if (classElement.getKind() == ElementKind.CLASS) {
            kind = Kind.CLASS;
        } else if (classElement.getKind() == ElementKind.ANNOTATION_TYPE) {
            kind = Kind.ANNOTATION;
        } else if (classElement.getKind() == ElementKind.ENUM) {
            kind = Kind.ENUM;
        }
        String comments = AptContext.getContext().getElements().getDocComment(classElement);
        ArrayList commentList = Strings.isNullOrEmpty((String)comments) ? new ArrayList() : Arrays.stream(comments.split(NEWLINE_PATTERN)).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        for (TypeMirror typeMirror : classElement.getInterfaces()) {
            TypeRef interfaceType = this.referenceAdapterFunction.apply(typeMirror);
            if (interfaceType instanceof ClassRef) {
                interfaces.add((ClassRef)interfaceType);
                continue;
            }
            throw new IllegalStateException("Interface: [" + interfaceType + "] not mapped to a class ref.");
        }
        for (TypeParameterElement typeParameterElement : classElement.getTypeParameters()) {
            TypeParamDef genericType = this.typeParamAdapterFunction.apply(typeParameterElement);
            genericTypes.add(genericType);
        }
        TypeDef baseType = ((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)((TypeDefBuilder)new TypeDefBuilder().withComments(commentList)).withKind(kind)).withModifiers(Modifiers.from(classElement.getModifiers()))).withPackageName(Apt.getPackageName(classElement))).withName(Apt.getClassName(classElement))).withParameters(genericTypes)).withExtendsList(new ClassRef[]{superClassType instanceof ClassRef ? superClassType : null})).withImplementsList(interfaces)).withOuterTypeName(classElement.getEnclosingElement() instanceof TypeElement ? classElement.getEnclosingElement().toString() : null)).build();
        this.context.getDefinitionRepository().registerIfAbsent(baseType);
        ArrayList<TypeDef> arrayList = new ArrayList<TypeDef>();
        for (TypeElement typeElement : ElementFilter.typesIn(classElement.getEnclosedElements())) {
            TypeDef typeDef = this.context.getDefinitionRepository().register(this.apply(typeElement));
            if (typeDef == null) {
                throw new IllegalStateException("Inner type for:" + typeElement + " is null");
            }
            TypeDef typeDef2 = ((TypeDefBuilder)new TypeDefBuilder(typeDef).withOuterTypeName(baseType.getFullyQualifiedName())).build();
            this.context.getDefinitionRepository().register(typeDef2);
            arrayList.add(typeDef2);
        }
        TypeDefBuilder builder = (TypeDefBuilder)new TypeDefBuilder(baseType).withInnerTypes(arrayList);
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(classElement.getEnclosedElements())) {
            builder.addToConstructors(new Method[]{this.methodAdapterFunction.apply(executableElement)});
        }
        for (VariableElement variableElement : ElementFilter.fieldsIn(classElement.getEnclosedElements())) {
            builder.addToProperties(new Property[]{this.propertyAdapterFunction.apply(variableElement)});
        }
        LinkedHashSet<ExecutableElement> linkedHashSet = new LinkedHashSet<ExecutableElement>();
        linkedHashSet.addAll(ElementFilter.methodsIn(classElement.getEnclosedElements()));
        linkedHashSet.addAll(this.getInheritedMethods(classElement));
        for (ExecutableElement executableElement : linkedHashSet) {
            builder.addToMethods(new Method[]{this.methodAdapterFunction.apply(executableElement)});
        }
        for (AnnotationMirror annotationMirror : classElement.getAnnotationMirrors()) {
            builder.addToAnnotations(new AnnotationRef[]{this.annotationAdapterFunction.apply(annotationMirror)});
        }
        TypeDef typeDef = this.context.getDefinitionRepository().register(builder.build());
        if (this.context.isDeep()) {
            HashSet<TypeElement> hashSet = new HashSet<TypeElement>(this.context.getReferences());
            hashSet.stream().filter(t -> !t.equals(classElement)).filter(t -> !t.toString().startsWith("sun.") && !t.toString().startsWith(COM_SUN_PREFIX)).forEach(t -> {
                String fqcn = t.toString();
                TypeDef existing = this.context.getDefinitionRepository().getDefinition(fqcn);
                if (existing == null) {
                    this.context.getDefinitionRepository().registerIfAbsent(fqcn, () -> this.apply((TypeElement)t));
                }
                this.context.getReferences().remove(t);
            });
        }
        return typeDef;
    }

    public Set<ExecutableElement> getInheritedMethods(TypeElement typeElement) {
        LinkedHashSet<ExecutableElement> result = new LinkedHashSet<ExecutableElement>();
        if (typeElement != null) {
            for (ExecutableElement method : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (method.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                result.add(method);
            }
            result.addAll(this.getInheritedMethods(typeElement.getSuperclass() != null ? AptContext.getContext().getElements().getTypeElement(typeElement.getSuperclass().toString()) : null));
        }
        return result;
    }
}

