/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source;

import com.github.javaparser.ast.body.BaseParameter;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.source.ClassOrInterfaceToTypeRef;
import io.sundr.adapter.source.SourceAdapter;
import io.sundr.adapter.source.StatementConverter;
import io.sundr.adapter.source.TypeToTypeRef;
import io.sundr.model.Assign;
import io.sundr.model.BitwiseAnd;
import io.sundr.model.BitwiseOr;
import io.sundr.model.Cast;
import io.sundr.model.ClassRef;
import io.sundr.model.Construct;
import io.sundr.model.ContextRef;
import io.sundr.model.Declare;
import io.sundr.model.Divide;
import io.sundr.model.Enclosed;
import io.sundr.model.Equals;
import io.sundr.model.Expression;
import io.sundr.model.GreaterThan;
import io.sundr.model.GreaterThanOrEqual;
import io.sundr.model.Index;
import io.sundr.model.InstanceOf;
import io.sundr.model.Inverse;
import io.sundr.model.Lambda;
import io.sundr.model.LeftShift;
import io.sundr.model.LessThan;
import io.sundr.model.LessThanOrEqual;
import io.sundr.model.LogicalAnd;
import io.sundr.model.LogicalOr;
import io.sundr.model.MethodCall;
import io.sundr.model.Minus;
import io.sundr.model.Modulo;
import io.sundr.model.Multiply;
import io.sundr.model.Negative;
import io.sundr.model.Not;
import io.sundr.model.NotEquals;
import io.sundr.model.Plus;
import io.sundr.model.Positive;
import io.sundr.model.PostDecrement;
import io.sundr.model.PostIncrement;
import io.sundr.model.PreDecrement;
import io.sundr.model.PreIncrement;
import io.sundr.model.Property;
import io.sundr.model.PropertyRef;
import io.sundr.model.Return;
import io.sundr.model.RightShift;
import io.sundr.model.RightUnsignedShift;
import io.sundr.model.Ternary;
import io.sundr.model.This;
import io.sundr.model.TypeRef;
import io.sundr.model.ValueRef;
import io.sundr.model.Xor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExpressionConverter {
    private static final ClassRef NUMBER = ClassRef.forName((String)Number.class.getName());
    private static final ClassRef OBJECT = ClassRef.forName((String)Object.class.getName());
    private static final SourceAdapter SOURCE_ADAPTER = new SourceAdapter(AdapterContext.getContext());
    private static final TypeToTypeRef TYPEREF_ADAPTER = new TypeToTypeRef(SOURCE_ADAPTER.getReferenceAdapterFunction());

    public static Declare convertVarDeclaration(VariableDeclarationExpr expr) {
        ClassOrInterfaceToTypeRef classOrInterfaceToTypeRef = new ClassOrInterfaceToTypeRef();
        TypeToTypeRef typeAdapter = new TypeToTypeRef(classOrInterfaceToTypeRef);
        TypeRef typeRef = typeAdapter.apply(expr.getType());
        List properties = expr.getVars().stream().map(v -> v.getId().getName()).map(n -> Property.newProperty((TypeRef)typeRef, (String)n)).collect(Collectors.toList());
        Optional<Object> initValue = Optional.empty();
        if (!expr.getVars().isEmpty() && ((VariableDeclarator)expr.getVars().get(0)).getInit() != null) {
            initValue = Optional.of(ExpressionConverter.convertExpression(((VariableDeclarator)expr.getVars().get(0)).getInit()));
        }
        return new Declare(properties, initValue);
    }

    public static Property convertParameter(Parameter parameter) {
        ClassOrInterfaceToTypeRef classOrInterfaceToTypeRef = new ClassOrInterfaceToTypeRef();
        TypeToTypeRef typeAdapter = new TypeToTypeRef(classOrInterfaceToTypeRef);
        TypeRef typeRef = typeAdapter.apply(parameter.getType());
        return Property.newProperty((TypeRef)typeRef, (String)parameter.getId().getName());
    }

    public static Expression convertExpression(com.github.javaparser.ast.expr.Expression expression) {
        if (expression instanceof AssignExpr) {
            AssignExpr assignExpr = (AssignExpr)expression;
            return new Assign(ExpressionConverter.convertExpression(assignExpr.getTarget()), ExpressionConverter.convertExpression(assignExpr.getValue()));
        }
        if (expression instanceof UnaryExpr) {
            UnaryExpr unaryExpr = (UnaryExpr)expression;
            switch (unaryExpr.getOperator()) {
                case positive: {
                    return new Positive(ExpressionConverter.convertExpression(unaryExpr.getExpr()));
                }
                case negative: {
                    return new Negative(ExpressionConverter.convertExpression(unaryExpr.getExpr()));
                }
                case preIncrement: {
                    return new PreIncrement(ExpressionConverter.convertExpression(unaryExpr.getExpr()));
                }
                case preDecrement: {
                    return new PreDecrement(ExpressionConverter.convertExpression(unaryExpr.getExpr()));
                }
                case posIncrement: {
                    return new PostIncrement(ExpressionConverter.convertExpression(unaryExpr.getExpr()));
                }
                case posDecrement: {
                    return new PostDecrement(ExpressionConverter.convertExpression(unaryExpr.getExpr()));
                }
                case not: {
                    return new Not(ExpressionConverter.convertExpression(unaryExpr.getExpr()));
                }
                case inverse: {
                    return new Inverse(ExpressionConverter.convertExpression(unaryExpr.getExpr()));
                }
            }
        } else {
            if (expression instanceof BinaryExpr) {
                BinaryExpr binaryExpr = (BinaryExpr)expression;
                Expression left = ExpressionConverter.convertExpression(binaryExpr.getLeft());
                Expression right = ExpressionConverter.convertExpression(binaryExpr.getRight());
                if (left == null || right == null) {
                    return null;
                }
                switch (binaryExpr.getOperator()) {
                    case plus: {
                        return new Plus(left, right);
                    }
                    case minus: {
                        return new Minus(left, right);
                    }
                    case and: {
                        return new LogicalAnd(left, right);
                    }
                    case or: {
                        return new LogicalOr(left, right);
                    }
                    case binOr: {
                        return new BitwiseOr(left, right);
                    }
                    case binAnd: {
                        return new BitwiseAnd(left, right);
                    }
                    case xor: {
                        return new Xor(left, right);
                    }
                    case equals: {
                        return new Equals(left, right);
                    }
                    case notEquals: {
                        return new NotEquals(left, right);
                    }
                    case greater: {
                        return new GreaterThan(left, right);
                    }
                    case greaterEquals: {
                        return new GreaterThanOrEqual(left, right);
                    }
                    case less: {
                        return new LessThan(left, right);
                    }
                    case lessEquals: {
                        return new LessThanOrEqual(left, right);
                    }
                    case times: {
                        return new Multiply(left, right);
                    }
                    case divide: {
                        return new Divide(left, right);
                    }
                    case remainder: {
                        return new Modulo(left, right);
                    }
                    case rSignedShift: {
                        return new RightShift(left, right);
                    }
                    case rUnsignedShift: {
                        return new RightUnsignedShift(left, right);
                    }
                    case lShift: {
                        return new LeftShift(left, right);
                    }
                }
                return null;
            }
            if (expression instanceof NameExpr) {
                NameExpr nameExpr = (NameExpr)expression;
                return new ContextRef(nameExpr.getName());
            }
            if (expression instanceof StringLiteralExpr) {
                StringLiteralExpr stringLiteralExpr = (StringLiteralExpr)expression;
                return new ValueRef((Object)stringLiteralExpr.getValue());
            }
            if (expression instanceof IntegerLiteralExpr) {
                IntegerLiteralExpr integerLiteralExpr = (IntegerLiteralExpr)expression;
                return new ValueRef((Object)integerLiteralExpr.getValue());
            }
            if (expression instanceof LongLiteralExpr) {
                LongLiteralExpr longLiteralExpr = (LongLiteralExpr)expression;
                return new ValueRef((Object)longLiteralExpr.getValue());
            }
            if (expression instanceof DoubleLiteralExpr) {
                DoubleLiteralExpr doubleLiteralExpr = (DoubleLiteralExpr)expression;
                return new ValueRef((Object)doubleLiteralExpr.getValue());
            }
            if (expression instanceof BooleanLiteralExpr) {
                BooleanLiteralExpr booleanLiteralExpr = (BooleanLiteralExpr)expression;
                return new ValueRef((Object)booleanLiteralExpr.getValue());
            }
            if (expression instanceof NullLiteralExpr) {
                return new ValueRef(null);
            }
            if (expression instanceof ThisExpr) {
                return new This();
            }
            if (expression instanceof ObjectCreationExpr) {
                ObjectCreationExpr objectCreationExpr = (ObjectCreationExpr)expression;
                ClassRef classRef = (ClassRef)SOURCE_ADAPTER.getReferenceAdapterFunction().apply(objectCreationExpr.getType());
                ArrayList<TypeRef> parameters = new ArrayList<TypeRef>();
                ArrayList<Expression> arguments = new ArrayList<Expression>();
                for (Type type : objectCreationExpr.getTypeArgs()) {
                    if (!(type instanceof ClassOrInterfaceType)) continue;
                    parameters.add(SOURCE_ADAPTER.getReferenceAdapterFunction().apply((ClassOrInterfaceType)type));
                }
                for (com.github.javaparser.ast.expr.Expression argument : objectCreationExpr.getArgs()) {
                    arguments.add(ExpressionConverter.convertExpression(argument));
                }
                return new Construct(classRef, parameters, arguments);
            }
            if (expression instanceof MethodCallExpr) {
                MethodCallExpr methodCallExpr = (MethodCallExpr)expression;
                String methodName = methodCallExpr.getName();
                ArrayList<TypeRef> parameters = new ArrayList<TypeRef>();
                ArrayList<Expression> arguments = new ArrayList<Expression>();
                for (Type type : methodCallExpr.getTypeArgs()) {
                    if (!(type instanceof ClassOrInterfaceType)) continue;
                    parameters.add(SOURCE_ADAPTER.getReferenceAdapterFunction().apply((ClassOrInterfaceType)type));
                }
                for (com.github.javaparser.ast.expr.Expression argument : methodCallExpr.getArgs()) {
                    arguments.add(ExpressionConverter.convertExpression(argument));
                }
                Expression scope = methodCallExpr.getScope() != null ? ExpressionConverter.convertExpression(methodCallExpr.getScope()) : null;
                return new MethodCall(methodName, scope, parameters, arguments);
            }
            if (expression instanceof LambdaExpr) {
                io.sundr.model.Statement bodyStatement;
                LambdaExpr lambdaExpr = (LambdaExpr)expression;
                Statement lambdaBody = lambdaExpr.getBody();
                if (lambdaBody instanceof ExpressionStmt) {
                    ExpressionStmt exprStmt = (ExpressionStmt)lambdaBody;
                    Expression expr = ExpressionConverter.convertExpression(exprStmt.getExpression());
                    bodyStatement = new Return(expr);
                } else {
                    bodyStatement = StatementConverter.convertStatement(lambdaBody);
                }
                return new Lambda(lambdaExpr.getParameters().stream().map(BaseParameter::getId).map(VariableDeclaratorId::getName).collect(Collectors.toList()), bodyStatement);
            }
            if (expression instanceof EnclosedExpr) {
                EnclosedExpr enclosedExpr = (EnclosedExpr)expression;
                return new Enclosed(ExpressionConverter.convertExpression(enclosedExpr.getInner()));
            }
            if (expression instanceof InstanceOfExpr) {
                InstanceOfExpr instanceOfExpr = (InstanceOfExpr)expression;
                Type type = instanceOfExpr.getType();
                if (type instanceof ClassOrInterfaceType) {
                    return new InstanceOf(ExpressionConverter.convertExpression(instanceOfExpr.getExpr()), (ClassRef)SOURCE_ADAPTER.getReferenceAdapterFunction().apply((ClassOrInterfaceType)type));
                }
                TypeRef typeRef = TYPEREF_ADAPTER.apply(type);
                if (typeRef instanceof ClassRef) {
                    return new InstanceOf(ExpressionConverter.convertExpression(instanceOfExpr.getExpr()), (ClassRef)typeRef);
                }
                return new InstanceOf(ExpressionConverter.convertExpression(instanceOfExpr.getExpr()), OBJECT);
            }
            if (expression instanceof ArrayAccessExpr) {
                ArrayAccessExpr arrayAccessExpr = (ArrayAccessExpr)expression;
                return new Index(ExpressionConverter.convertExpression(arrayAccessExpr.getName()), ExpressionConverter.convertExpression(arrayAccessExpr.getIndex()));
            }
            if (expression instanceof ConditionalExpr) {
                ConditionalExpr conditionalExpr = (ConditionalExpr)expression;
                return new Ternary(ExpressionConverter.convertExpression(conditionalExpr.getCondition()), ExpressionConverter.convertExpression(conditionalExpr.getThenExpr()), ExpressionConverter.convertExpression(conditionalExpr.getElseExpr()));
            }
            if (expression instanceof MethodReferenceExpr) {
                MethodReferenceExpr methodReferenceExpr = (MethodReferenceExpr)expression;
                String methodName = methodReferenceExpr.getIdentifier();
                ArrayList parameters = new ArrayList();
                ArrayList arguments = new ArrayList();
                Expression scope = methodReferenceExpr.getScope() != null ? ExpressionConverter.convertExpression(methodReferenceExpr.getScope()) : null;
                return new MethodCall(methodName, scope, parameters, arguments);
            }
            if (expression instanceof VariableDeclarationExpr) {
                VariableDeclarationExpr varDeclExpr = (VariableDeclarationExpr)expression;
                if (!varDeclExpr.getVars().isEmpty()) {
                    VariableDeclarator var = (VariableDeclarator)varDeclExpr.getVars().get(0);
                    String varName = var.getId().getName();
                    Property prop = Property.newProperty((TypeRef)OBJECT, (String)varName);
                    if (var.getInit() != null) {
                        Expression initExpr = ExpressionConverter.convertExpression(var.getInit());
                        return new Declare(prop, initExpr);
                    }
                    return new Declare(prop);
                }
                return null;
            }
            if (expression instanceof FieldAccessExpr) {
                FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)expression;
                String fieldName = fieldAccessExpr.getFieldExpr().getName();
                Expression scope = ExpressionConverter.convertExpression(fieldAccessExpr.getScope());
                return new PropertyRef(fieldName, scope);
            }
            if (expression instanceof TypeExpr) {
                TypeExpr typeExpr = (TypeExpr)expression;
                return new ContextRef(typeExpr.getType().toString());
            }
            if (expression instanceof ClassExpr) {
                ClassExpr classExpr = (ClassExpr)expression;
                TypeRef typeRef = TYPEREF_ADAPTER.apply(classExpr.getType());
                if (typeRef instanceof ClassRef) {
                    return ((ClassRef)typeRef).dotClass();
                }
                return new ContextRef(typeRef.toString() + ".class");
            }
            if (expression instanceof CastExpr) {
                CastExpr castExpr = (CastExpr)expression;
                TypeRef targetType = TYPEREF_ADAPTER.apply(castExpr.getType());
                Expression expr = ExpressionConverter.convertExpression(castExpr.getExpr());
                return new Cast(targetType, expr);
            }
        }
        return null;
    }
}

