/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source;

import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.source.analysis.ImpactAnalysisResult;
import io.sundr.adapter.source.analysis.ImpactAnalyzer;
import io.sundr.adapter.source.change.ChangeDetector;
import io.sundr.adapter.source.change.ChangeSet;
import io.sundr.adapter.source.utils.Sources;
import io.sundr.model.Nameable;
import io.sundr.model.TypeDef;
import io.sundr.model.repo.DefinitionRepository;
import io.sundr.utils.Patterns;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Project {
    public static final File DIR = new File(".");
    public static final String NEWLINE = "\n";
    public static final String GIT = System.getProperty(".git");
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String CURRENT_DIR = System.getProperty("user.dir");
    private final File moduleRoot;
    private final File src;
    private final File srcMain;
    private final File srcMainJava;
    private final File srcTest;
    private final File srcTestJava;

    public Project(File moduleRoot) {
        this.moduleRoot = moduleRoot;
        this.src = new File(moduleRoot, "src");
        this.srcMain = new File(this.src, "main");
        this.srcMainJava = new File(this.srcMain, "java");
        this.srcTest = new File(this.src, "test");
        this.srcTestJava = new File(this.srcTest, "java");
    }

    public static Project getProject() {
        return new Project(Project.moduleRoot());
    }

    public static Project getProject(Path projectRoot) {
        return new Project(projectRoot.toFile());
    }

    public File getModuleRoot() {
        return this.moduleRoot;
    }

    public File getSrc() {
        return this.src;
    }

    public File getSrcMain() {
        return this.srcMain;
    }

    public File getSrcMainJava() {
        return this.srcMainJava;
    }

    public File getSrcTest() {
        return this.srcTest;
    }

    public File getSrcTestJava() {
        return this.srcTestJava;
    }

    private static File moduleRoot() {
        File currentDir;
        for (currentDir = Optional.ofNullable(CURRENT_DIR).map(File::new).orElse(DIR); currentDir != null; currentDir = currentDir.getParentFile()) {
            if (currentDir.getAbsolutePath().equals(USER_HOME)) {
                return currentDir;
            }
            File gitDir = new File(currentDir, ".git");
            if (gitDir.exists() && gitDir.isDirectory()) {
                return currentDir;
            }
            File pomFile = new File(currentDir, "pom.xml");
            File gradleFile = new File(currentDir, "build.gradle");
            if (!pomFile.exists() && !gradleFile.exists()) continue;
            return currentDir;
        }
        return currentDir;
    }

    public static Optional<String> packageOf(String fqcn) {
        return fqcn.contains(".") ? Optional.of(fqcn.substring(0, fqcn.lastIndexOf("."))) : Optional.empty();
    }

    public static String classNameOf(String fqcn) {
        return fqcn.substring(fqcn.lastIndexOf(".") + 1);
    }

    private Optional<Path> findJavaFile(File sourceRoot, String fqcn) {
        Optional<Path> optional;
        block9: {
            Optional<String> packageName = Project.packageOf(fqcn);
            String className = Project.classNameOf(fqcn);
            if (packageName.isPresent()) {
                Optional<Path> path = packageName.map(p -> p.replace(".", File.separator)).map(p -> new File(sourceRoot, (String)p)).map(f -> new File((File)f, className + ".java")).filter(File::exists).map(File::toPath);
                return path;
            }
            Stream<Path> paths = Files.walk(sourceRoot.toPath(), new FileVisitOption[0]);
            try {
                optional = paths.filter(p -> p.toFile().getName().equals(className + ".java")).findFirst();
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            paths.close();
        }
        return optional;
    }

    public Optional<Path> findJavaSourceFile(String fqcn) {
        return this.findJavaFile(this.srcMainJava, fqcn);
    }

    public Optional<Path> findJavaTestFile(String fqcn) {
        return this.findJavaFile(this.srcTestJava, fqcn);
    }

    public static String readFile(Path path) {
        try {
            return Files.readAllLines(path).stream().collect(Collectors.joining(NEWLINE));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    TypeDef parse(Path path) {
        TypeDef typeDef;
        AdapterContext context = AdapterContext.create((DefinitionRepository)DefinitionRepository.getRepository());
        FileInputStream fis = new FileInputStream(path.toFile());
        try {
            typeDef = Sources.readTypeDefFromStream(fis, context);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read TypeDef from " + String.valueOf(path), e);
            }
        }
        fis.close();
        return typeDef;
    }

    public List<Path> listJavaSourceFiles() {
        List<Path> list;
        block9: {
            if (!this.srcMainJava.exists()) {
                return List.of();
            }
            Stream<Path> paths = Files.walk(this.srcMainJava.toPath(), new FileVisitOption[0]);
            try {
                list = paths.filter(p -> p.toFile().isFile() && p.toString().endsWith(".java")).collect(Collectors.toList());
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            paths.close();
        }
        return list;
    }

    public List<Path> listJavaTestFiles() {
        List<Path> list;
        block9: {
            if (!this.srcTestJava.exists()) {
                return List.of();
            }
            Stream<Path> paths = Files.walk(this.srcTestJava.toPath(), new FileVisitOption[0]);
            try {
                list = paths.filter(p -> p.toFile().isFile() && p.toString().endsWith(".java")).collect(Collectors.toList());
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            paths.close();
        }
        return list;
    }

    public List<Path> listJavaFiles() {
        List<Path> allFiles = this.listJavaSourceFiles();
        allFiles.addAll(this.listJavaTestFiles());
        return allFiles;
    }

    public SourceSelector sources() {
        return new SourceSelector(SourceType.SOURCES);
    }

    public SourceSelector testSources() {
        return new SourceSelector(SourceType.TEST_SOURCES);
    }

    public SourceSelector allSources() {
        return new SourceSelector(SourceType.ALL_SOURCES);
    }

    public ImpactAnalysisResult analyzeImpact(ChangeSet changeSet) {
        ImpactAnalyzer analyzer = new ImpactAnalyzer(this);
        return analyzer.analyze(changeSet);
    }

    public class SourceSelector {
        private final SourceType sourceType;
        private String[] includePatterns = new String[0];
        private String[] excludePatterns = new String[0];

        private SourceSelector(SourceType sourceType) {
            this.sourceType = sourceType;
        }

        public SourceSelector including(String ... patterns) {
            this.includePatterns = patterns != null ? patterns : new String[]{};
            return this;
        }

        public SourceSelector excluding(String ... patterns) {
            this.excludePatterns = patterns != null ? patterns : new String[]{};
            return this;
        }

        public List<Path> list() {
            List<Path> baseFiles;
            switch (this.sourceType) {
                case SOURCES: {
                    baseFiles = Project.this.listJavaSourceFiles();
                    break;
                }
                case TEST_SOURCES: {
                    baseFiles = Project.this.listJavaTestFiles();
                    break;
                }
                default: {
                    baseFiles = Project.this.listJavaFiles();
                }
            }
            return baseFiles.stream().filter(this::matchesIncludePatterns).filter(this::matchesExcludePatterns).collect(Collectors.toList());
        }

        public Optional<Path> find(String fqcn) {
            if (fqcn == null || fqcn.trim().isEmpty()) {
                return Optional.empty();
            }
            List<Path> filteredFiles = this.list();
            return filteredFiles.stream().filter(path -> this.matchesFQCN((Path)path, fqcn)).findFirst();
        }

        public Optional<Path> find(Nameable nameable) {
            return this.find(nameable.getFullyQualifiedName());
        }

        private boolean matchesFQCN(Path filePath, String fqcn) {
            Optional<String> packageName = Project.packageOf(fqcn);
            String className = Project.classNameOf(fqcn);
            String fileName = filePath.getFileName().toString();
            if (!fileName.equals(className + ".java")) {
                return false;
            }
            if (!packageName.isPresent()) {
                return true;
            }
            String expectedPackagePath = packageName.get().replace(".", File.separator);
            String filePathString = filePath.toString();
            return filePathString.contains(expectedPackagePath + File.separator + fileName);
        }

        private boolean matchesIncludePatterns(Path path) {
            if (this.includePatterns.length == 0) {
                return true;
            }
            String fileName = path.getFileName().toString();
            return Patterns.isIncluded((String)fileName, (String[])this.includePatterns);
        }

        private boolean matchesExcludePatterns(Path path) {
            if (this.excludePatterns.length == 0) {
                return true;
            }
            String fileName = path.getFileName().toString();
            return !Patterns.isExcluded((String)fileName, (String[])this.excludePatterns);
        }

        public CompletableFuture<Void> watch(Consumer<ChangeSet> changeConsumer) {
            return CompletableFuture.runAsync(() -> {
                ConcurrentHashMap<Path, TypeDef> previousStates = new ConcurrentHashMap<Path, TypeDef>();
                ConcurrentHashMap<Path, PendingEvent> pendingEvents = new ConcurrentHashMap<Path, PendingEvent>();
                ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
                for (Path path : this.list()) {
                    try {
                        TypeDef typeDef = Project.this.parse(path);
                        previousStates.put(path, typeDef);
                    }
                    catch (Exception typeDef) {}
                }
                try (WatchService watchService = Project.this.moduleRoot.toPath().getFileSystem().newWatchService();){
                    this.registerWatchDirectories(watchService);
                    while (!Thread.currentThread().isInterrupted()) {
                        WatchKey key;
                        try {
                            key = watchService.take();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        for (WatchEvent<?> event : key.pollEvents()) {
                            WatchEvent.Kind<?> kind = event.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                            WatchEvent<?> pathEvent = event;
                            Path changedPath = ((Path)key.watchable()).resolve((Path)pathEvent.context());
                            if (!changedPath.toString().endsWith(".java") || !this.matchesIncludePatterns(changedPath) || !this.matchesExcludePatterns(changedPath)) continue;
                            this.handleFileEventWithBuffering(changedPath, kind, previousStates, pendingEvents, scheduler, changeConsumer);
                        }
                        boolean valid = key.reset();
                        if (valid) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error watching files", e);
                }
                finally {
                    scheduler.shutdown();
                }
            });
        }

        private void handleFileEventWithBuffering(Path changedPath, WatchEvent.Kind<?> kind, Map<Path, TypeDef> previousStates, Map<Path, PendingEvent> pendingEvents, ScheduledExecutorService scheduler, Consumer<ChangeSet> changeConsumer) {
            PendingEvent existingEvent = pendingEvents.get(changedPath);
            if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                if (existingEvent != null) {
                    existingEvent.cancel();
                }
                PendingEvent deleteEvent = new PendingEvent(changedPath, kind, previousStates.get(changedPath));
                pendingEvents.put(changedPath, deleteEvent);
                deleteEvent.scheduledFuture = scheduler.schedule(() -> {
                    pendingEvents.remove(changedPath);
                    this.processDeleteEvent(changedPath, previousStates, changeConsumer);
                }, 100L, TimeUnit.MILLISECONDS);
            } else if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                if (existingEvent != null && existingEvent.kind == StandardWatchEventKinds.ENTRY_DELETE) {
                    existingEvent.cancel();
                    pendingEvents.remove(changedPath);
                    this.processModifyEvent(changedPath, previousStates, changeConsumer);
                } else {
                    this.processCreateEvent(changedPath, previousStates, changeConsumer);
                }
            } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                if (existingEvent != null) {
                    existingEvent.cancel();
                    pendingEvents.remove(changedPath);
                }
                this.processModifyEvent(changedPath, previousStates, changeConsumer);
            }
        }

        private void processDeleteEvent(Path changedPath, Map<Path, TypeDef> previousStates, Consumer<ChangeSet> changeConsumer) {
            TypeDef previousTypeDef = previousStates.get(changedPath);
            if (previousTypeDef != null) {
                try {
                    ChangeSet changeSet = ChangeDetector.compare(previousTypeDef, (TypeDef)null);
                    changeConsumer.accept(changeSet);
                }
                catch (Exception e) {
                    System.err.println("Error processing delete for " + String.valueOf(changedPath) + ": " + e.getMessage());
                }
                previousStates.remove(changedPath);
            }
        }

        private void processCreateEvent(Path changedPath, Map<Path, TypeDef> previousStates, Consumer<ChangeSet> changeConsumer) {
            try {
                TypeDef newTypeDef = Project.this.parse(changedPath);
                ChangeSet changeSet = ChangeDetector.compare((TypeDef)null, newTypeDef);
                changeConsumer.accept(changeSet);
                previousStates.put(changedPath, newTypeDef);
            }
            catch (Exception e) {
                System.err.println("Error processing create for " + String.valueOf(changedPath) + ": " + e.getMessage());
            }
        }

        private void processModifyEvent(Path changedPath, Map<Path, TypeDef> previousStates, Consumer<ChangeSet> changeConsumer) {
            try {
                TypeDef previousTypeDef = previousStates.get(changedPath);
                TypeDef newTypeDef = Project.this.parse(changedPath);
                ChangeSet changeSet = previousTypeDef != null ? ChangeDetector.compare(previousTypeDef, newTypeDef) : ChangeDetector.compare((TypeDef)null, newTypeDef);
                if (changeSet.hasChanges()) {
                    changeConsumer.accept(changeSet);
                }
                previousStates.put(changedPath, newTypeDef);
            }
            catch (Exception e) {
                System.err.println("Error processing modify for " + String.valueOf(changedPath) + ": " + e.getMessage());
            }
        }

        private void registerWatchDirectories(WatchService watchService) throws Exception {
            switch (this.sourceType) {
                case SOURCES: {
                    if (!Project.this.srcMainJava.exists()) break;
                    this.registerDirectoryTree(Project.this.srcMainJava.toPath(), watchService);
                    break;
                }
                case TEST_SOURCES: {
                    if (!Project.this.srcTestJava.exists()) break;
                    this.registerDirectoryTree(Project.this.srcTestJava.toPath(), watchService);
                    break;
                }
                default: {
                    if (Project.this.srcMainJava.exists()) {
                        this.registerDirectoryTree(Project.this.srcMainJava.toPath(), watchService);
                    }
                    if (!Project.this.srcTestJava.exists()) break;
                    this.registerDirectoryTree(Project.this.srcTestJava.toPath(), watchService);
                }
            }
        }

        private void registerDirectoryTree(Path root, WatchService watchService) throws Exception {
            Files.walk(root, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(dir -> {
                try {
                    dir.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to register directory: " + String.valueOf(dir), e);
                }
            });
        }
    }

    public static enum SourceType {
        SOURCES,
        TEST_SOURCES,
        ALL_SOURCES;

    }

    private static class PendingEvent {
        final Path path;
        final WatchEvent.Kind<?> kind;
        final TypeDef previousState;
        volatile ScheduledFuture<?> scheduledFuture;

        PendingEvent(Path path, WatchEvent.Kind<?> kind, TypeDef previousState) {
            this.path = path;
            this.kind = kind;
            this.previousState = previousState;
        }

        void cancel() {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
        }
    }
}

