/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source.change;

import io.sundr.adapter.source.change.ChangeType;

public class Change<T> {
    private final ChangeType changeType;
    private final T oldElement;
    private final T newElement;

    private Change(ChangeType changeType, T oldElement, T newElement) {
        this.changeType = changeType;
        this.oldElement = oldElement;
        this.newElement = newElement;
    }

    public static <T> Change<T> added(T newElement) {
        return new Change<Object>(ChangeType.ADDED, null, newElement);
    }

    public static <T> Change<T> removed(T oldElement) {
        return new Change<Object>(ChangeType.REMOVED, oldElement, null);
    }

    public static <T> Change<T> modified(T oldElement, T newElement) {
        return new Change<T>(ChangeType.MODIFIED, oldElement, newElement);
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public T getOldElement() {
        return this.oldElement;
    }

    public T getNewElement() {
        return this.newElement;
    }

    public T getElement() {
        return this.newElement != null ? this.newElement : this.oldElement;
    }

    public String toString() {
        switch (this.changeType) {
            case ADDED: {
                return "ADDED: " + String.valueOf(this.newElement);
            }
            case REMOVED: {
                return "REMOVED: " + String.valueOf(this.oldElement);
            }
            case MODIFIED: {
                return "MODIFIED: " + String.valueOf(this.oldElement) + " -> " + String.valueOf(this.newElement);
            }
        }
        return String.valueOf((Object)this.changeType) + ": " + String.valueOf(this.getElement());
    }
}

