/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source.change;

import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.source.change.Change;
import io.sundr.adapter.source.change.ChangeSet;
import io.sundr.adapter.source.utils.Sources;
import io.sundr.model.Method;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.repo.DefinitionRepository;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ChangeDetector {
    public static ChangeSet compare(TypeDef oldTypeDef, TypeDef newTypeDef) {
        Set<Change<Method>> methodChanges = ChangeDetector.compareMethodsAsSets(oldTypeDef, newTypeDef);
        Set<Change<Property>> propertyChanges = ChangeDetector.comparePropertiesAsSets(oldTypeDef, newTypeDef);
        return new ChangeSet(oldTypeDef, newTypeDef, methodChanges, propertyChanges);
    }

    public static ChangeSet compare(Path oldFile, Path newFile) throws IOException {
        AdapterContext context = AdapterContext.create((DefinitionRepository)DefinitionRepository.getRepository());
        TypeDef oldTypeDef = ChangeDetector.readTypeDefFromFile(oldFile, context);
        TypeDef newTypeDef = ChangeDetector.readTypeDefFromFile(newFile, context);
        return ChangeDetector.compare(oldTypeDef, newTypeDef);
    }

    public static ChangeSet compare(TypeDef oldTypeDef, Path newFile) throws IOException {
        AdapterContext context = AdapterContext.create((DefinitionRepository)DefinitionRepository.getRepository());
        TypeDef newTypeDef = ChangeDetector.readTypeDefFromFile(newFile, context);
        return ChangeDetector.compare(oldTypeDef, newTypeDef);
    }

    public static ChangeSet compare(Path oldFile, TypeDef newTypeDef) throws IOException {
        AdapterContext context = AdapterContext.create((DefinitionRepository)DefinitionRepository.getRepository());
        TypeDef oldTypeDef = ChangeDetector.readTypeDefFromFile(oldFile, context);
        return ChangeDetector.compare(oldTypeDef, newTypeDef);
    }

    private static Set<Change<Method>> compareMethodsAsSets(TypeDef oldTypeDef, TypeDef newTypeDef) {
        HashSet<Change<Method>> changes = new HashSet<Change<Method>>();
        Map oldMethods = oldTypeDef != null ? oldTypeDef.getMethods().stream().collect(Collectors.toMap(ChangeDetector::createMethodSignature, method -> method)) : Collections.emptyMap();
        Map newMethods = newTypeDef != null ? newTypeDef.getMethods().stream().collect(Collectors.toMap(ChangeDetector::createMethodSignature, method -> method)) : Collections.emptyMap();
        for (Map.Entry entry : newMethods.entrySet()) {
            if (oldMethods.containsKey(entry.getKey())) continue;
            changes.add(Change.added((Method)entry.getValue()));
        }
        for (Map.Entry entry : oldMethods.entrySet()) {
            if (newMethods.containsKey(entry.getKey())) continue;
            changes.add(Change.removed((Method)entry.getValue()));
        }
        for (Map.Entry entry : oldMethods.entrySet()) {
            String signature = (String)entry.getKey();
            Method oldMethod = (Method)entry.getValue();
            Method newMethod = (Method)newMethods.get(signature);
            if (newMethod == null || ChangeDetector.methodsEqual(oldMethod, newMethod)) continue;
            changes.add(Change.modified(oldMethod, newMethod));
        }
        return changes;
    }

    private static Set<Change<Property>> comparePropertiesAsSets(TypeDef oldTypeDef, TypeDef newTypeDef) {
        HashSet<Change<Property>> changes = new HashSet<Change<Property>>();
        Map oldProperties = oldTypeDef != null ? oldTypeDef.getProperties().stream().collect(Collectors.toMap(Property::getName, property -> property)) : Collections.emptyMap();
        Map newProperties = newTypeDef != null ? newTypeDef.getProperties().stream().collect(Collectors.toMap(Property::getName, property -> property)) : Collections.emptyMap();
        for (Map.Entry entry : newProperties.entrySet()) {
            if (oldProperties.containsKey(entry.getKey())) continue;
            changes.add(Change.added((Property)entry.getValue()));
        }
        for (Map.Entry entry : oldProperties.entrySet()) {
            if (newProperties.containsKey(entry.getKey())) continue;
            changes.add(Change.removed((Property)entry.getValue()));
        }
        for (Map.Entry entry : oldProperties.entrySet()) {
            String name = (String)entry.getKey();
            Property oldProperty = (Property)entry.getValue();
            Property newProperty = (Property)newProperties.get(name);
            if (newProperty == null || ChangeDetector.propertiesEqual(oldProperty, newProperty)) continue;
            changes.add(Change.modified(oldProperty, newProperty));
        }
        return changes;
    }

    private static String createMethodSignature(Method method) {
        StringBuilder signature = new StringBuilder();
        signature.append(method.getName()).append("(");
        method.getArguments().forEach(arg -> signature.append(arg.getTypeRef().toString()).append(","));
        signature.append(")");
        return signature.toString();
    }

    private static boolean methodsEqual(Method method1, Method method2) {
        String block2Str;
        if (!Objects.equals(method1.getReturnType(), method2.getReturnType())) {
            return false;
        }
        if (!Objects.equals(method1.getModifiers(), method2.getModifiers())) {
            return false;
        }
        String block1Str = method1.getBlock() != null ? ChangeDetector.normalizeCode(method1.getBlock().render()) : null;
        String string = block2Str = method2.getBlock() != null ? ChangeDetector.normalizeCode(method2.getBlock().render()) : null;
        return Objects.equals(block1Str, block2Str);
    }

    private static boolean propertiesEqual(Property prop1, Property prop2) {
        if (!Objects.equals(prop1.getTypeRef(), prop2.getTypeRef())) {
            return false;
        }
        return Objects.equals(prop1.getModifiers(), prop2.getModifiers());
    }

    private static TypeDef readTypeDefFromFile(Path filePath, AdapterContext context) throws IOException {
        try (FileInputStream fis = new FileInputStream(filePath.toFile());){
            TypeDef typeDef = Sources.readTypeDefFromStream(fis, context);
            return typeDef;
        }
    }

    private static String normalizeCode(String code) {
        if (code == null) {
            return null;
        }
        code = code.replaceAll("//.*?(?=\n|$)", "");
        code = code.replaceAll("/\\*.*?\\*/", "");
        code = code.replaceAll("\\s+", " ");
        code = code.trim();
        return code;
    }
}

