/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source.utils;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.TypeDeclaration;
import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.api.AdapterContextAware;
import io.sundr.adapter.api.Adapters;
import io.sundr.model.TypeDef;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Sources {
    private static final String NO_TYPE_FOUND = "No type found in the stream.";
    private static final Function<File, CompilationUnit> FROM_FILE_TO_COMPILATIONUNIT = file -> {
        CompilationUnit compilationUnit;
        FileInputStream fis = new FileInputStream((File)file);
        try {
            compilationUnit = JavaParser.parse((InputStream)fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to load file: [" + file.getAbsolutePath() + "] from file system.");
            }
        }
        fis.close();
        return compilationUnit;
    };
    private static final Function<String, CompilationUnit> FROM_CLASSPATH_TO_COMPILATIONUNIT = resource -> {
        CompilationUnit compilationUnit;
        block8: {
            InputStream is = Sources.class.getClassLoader().getResourceAsStream((String)resource);
            try {
                compilationUnit = JavaParser.parse((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to load resource: [" + resource + "] from classpath.");
                }
            }
            is.close();
        }
        return compilationUnit;
    };
    private static final Function<InputStream, CompilationUnit> FROM_INPUTSTREAM_TO_COMPILATIONUNIT = is -> {
        CompilationUnit compilationUnit;
        try {
            compilationUnit = JavaParser.parse((InputStream)is);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Failed to parse stream.", ex);
            }
            catch (Throwable throwable) {
                Sources.closeQuietly(is);
                throw throwable;
            }
        }
        Sources.closeQuietly(is);
        return compilationUnit;
    };

    public static TypeDef readTypeDefFromPath(Path path, AdapterContext ctx) {
        TypeDef typeDef;
        FileInputStream is = new FileInputStream(path.toFile());
        try {
            typeDef = Sources.readTypeDefFromStream(is, ctx);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read file from path: " + String.valueOf(path), e);
            }
        }
        ((InputStream)is).close();
        return typeDef;
    }

    public static TypeDef readTypeDefFromStream(InputStream is, AdapterContext ctx) {
        return (TypeDef)Sources.readTypeDefsFromStream(is, ctx).stream().findFirst().orElseThrow(() -> new IllegalStateException(NO_TYPE_FOUND));
    }

    public static List<TypeDef> readTypeDefsFromStream(InputStream is, AdapterContext ctx) {
        CompilationUnit cu = FROM_INPUTSTREAM_TO_COMPILATIONUNIT.apply(is);
        return cu.getTypes().stream().map(t -> Adapters.adaptType((Object)t, (AdapterContextAware)ctx)).collect(Collectors.toList());
    }

    public static List<TypeDeclaration> readTypesFromStream(InputStream is) {
        CompilationUnit cu = FROM_INPUTSTREAM_TO_COMPILATIONUNIT.apply(is);
        return cu.getTypes();
    }

    public static TypeDeclaration readTypeFromStream(InputStream is) {
        return (TypeDeclaration)Sources.readTypesFromStream(is).stream().findFirst().orElseThrow(() -> new IllegalStateException(NO_TYPE_FOUND));
    }

    public static List<TypeDeclaration> readTypesFromResource(String resourceName) {
        CompilationUnit cu = FROM_CLASSPATH_TO_COMPILATIONUNIT.apply(resourceName);
        return cu.getTypes();
    }

    public static TypeDeclaration readTypeFromResource(String resourceName) {
        return (TypeDeclaration)Sources.readTypesFromResource(resourceName).stream().findFirst().orElseThrow(() -> new IllegalStateException(NO_TYPE_FOUND));
    }

    public static TypeDef readTypeDefFromResource(String resourceName, AdapterContext ctx) {
        return (TypeDef)Sources.readTypeDefsFromResource(resourceName, ctx).stream().findFirst().orElseThrow(() -> new IllegalStateException(NO_TYPE_FOUND));
    }

    public static List<TypeDef> readTypeDefsFromResource(String resourceName, AdapterContext ctx) {
        CompilationUnit cu = FROM_CLASSPATH_TO_COMPILATIONUNIT.apply(resourceName);
        return cu.getTypes().stream().map(t -> Adapters.adaptType((Object)t, (AdapterContextAware)ctx)).collect(Collectors.toList());
    }

    private static void closeQuietly(Closeable ... cloasebales) {
        if (cloasebales != null) {
            for (Closeable c : cloasebales) {
                try {
                    if (c == null) continue;
                    c.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

