/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source;

import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ContinueStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.ForeachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.SynchronizedStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import io.sundr.adapter.source.BlockStmtToBlock;
import io.sundr.adapter.source.ExpressionConverter;
import io.sundr.model.Block;
import io.sundr.model.Break;
import io.sundr.model.Continue;
import io.sundr.model.Declare;
import io.sundr.model.Do;
import io.sundr.model.Empty;
import io.sundr.model.Expression;
import io.sundr.model.For;
import io.sundr.model.Foreach;
import io.sundr.model.If;
import io.sundr.model.MethodCall;
import io.sundr.model.Property;
import io.sundr.model.Return;
import io.sundr.model.Switch;
import io.sundr.model.Synchronized;
import io.sundr.model.Throw;
import io.sundr.model.Try;
import io.sundr.model.While;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class StatementConverter {
    public static io.sundr.model.Statement convertStatement(Statement statement) {
        if (statement == null) {
            return new Empty();
        }
        if (statement instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)statement;
            return If.condition((Expression)ExpressionConverter.convertExpression(ifStmt.getCondition())).then(new io.sundr.model.Statement[]{StatementConverter.convertStatement(ifStmt.getThenStmt())}).orElse(new io.sundr.model.Statement[]{StatementConverter.convertStatement(ifStmt.getElseStmt())});
        }
        if (statement instanceof WhileStmt) {
            WhileStmt whileStmt = (WhileStmt)statement;
            return While.condition((Expression)ExpressionConverter.convertExpression(whileStmt.getCondition())).body(new io.sundr.model.Statement[]{StatementConverter.convertStatement(whileStmt.getBody())});
        }
        if (statement instanceof ForStmt) {
            ForStmt forStmt = (ForStmt)statement;
            List initExpressions = forStmt.getInit().stream().map(ExpressionConverter::convertExpression).collect(Collectors.toList());
            List updateExpressions = forStmt.getUpdate().stream().map(ExpressionConverter::convertExpression).collect(Collectors.toList());
            return For.init(initExpressions).compare(ExpressionConverter.convertExpression(forStmt.getCompare())).update(updateExpressions).body(new io.sundr.model.Statement[]{StatementConverter.convertStatement(forStmt.getBody())});
        }
        if (statement instanceof ForeachStmt) {
            ForeachStmt foreachStmt = (ForeachStmt)statement;
            return new Foreach(ExpressionConverter.convertVarDeclaration(foreachStmt.getVariable()), ExpressionConverter.convertExpression(foreachStmt.getIterable()), StatementConverter.convertStatement(foreachStmt.getBody()));
        }
        if (statement instanceof DoStmt) {
            DoStmt doStmt = (DoStmt)statement;
            return new Do(ExpressionConverter.convertExpression(doStmt.getCondition()), StatementConverter.convertStatement(doStmt.getBody()));
        }
        if (statement instanceof BreakStmt) {
            return new Break();
        }
        if (statement instanceof ContinueStmt) {
            return new Continue();
        }
        if (statement instanceof ReturnStmt) {
            ReturnStmt returnStmt = (ReturnStmt)statement;
            return returnStmt.getExpr() != null ? new Return(ExpressionConverter.convertExpression(returnStmt.getExpr())) : Return.Nothing();
        }
        if (statement instanceof ThrowStmt) {
            ThrowStmt throwStmt = (ThrowStmt)statement;
            return new Throw(ExpressionConverter.convertExpression(throwStmt.getExpr()));
        }
        if (statement instanceof BlockStmt) {
            return new BlockStmtToBlock().apply((BlockStmt)statement);
        }
        if (statement instanceof ExpressionStmt) {
            ExpressionStmt exprStmt = (ExpressionStmt)statement;
            return (io.sundr.model.Statement)ExpressionConverter.convertExpression(exprStmt.getExpression());
        }
        if (statement instanceof SwitchStmt) {
            SwitchStmt switchStmt = (SwitchStmt)statement;
            return Switch.expression((Expression)ExpressionConverter.convertExpression(switchStmt.getSelector())).defaultCase(new io.sundr.model.Statement[0]);
        }
        if (statement instanceof EmptyStmt) {
            return new Empty();
        }
        if (statement instanceof TryStmt) {
            TryStmt tryStmt = (TryStmt)statement;
            ArrayList<Declare> resources = new ArrayList<Declare>();
            for (VariableDeclarationExpr resource : tryStmt.getResources()) {
                resources.add(ExpressionConverter.convertVarDeclaration(resource));
            }
            Block tryBlock = new BlockStmtToBlock().apply(tryStmt.getTryBlock());
            ArrayList<Try.Catch> catchBlocks = new ArrayList<Try.Catch>();
            for (CatchClause catchClause : tryStmt.getCatchs()) {
                Property parameter = ExpressionConverter.convertParameter(catchClause.getParam());
                Block catchBlock = new BlockStmtToBlock().apply(catchClause.getCatchBlock());
                catchBlocks.add(new Try.Catch(parameter, catchBlock));
            }
            Optional finallyBlock = tryStmt.getFinallyBlock() != null ? Optional.of(new BlockStmtToBlock().apply(tryStmt.getFinallyBlock())) : Optional.empty();
            return new Try(resources, tryBlock, catchBlocks, finallyBlock);
        }
        if (statement instanceof ExplicitConstructorInvocationStmt) {
            ExplicitConstructorInvocationStmt explicitStmt = (ExplicitConstructorInvocationStmt)statement;
            String methodName = explicitStmt.isThis() ? "this" : "super";
            List arguments = explicitStmt.getArgs().stream().map(ExpressionConverter::convertExpression).collect(Collectors.toList());
            return new MethodCall(methodName, null, Collections.emptyList(), arguments);
        }
        if (statement instanceof SynchronizedStmt) {
            SynchronizedStmt syncStmt = (SynchronizedStmt)statement;
            Expression lockExpression = ExpressionConverter.convertExpression(syncStmt.getExpr());
            Block body = new BlockStmtToBlock().apply(syncStmt.getBlock());
            return new Synchronized(lockExpression, (io.sundr.model.Statement)body);
        }
        throw new IllegalArgumentException("Statement of type " + statement.getClass().getName());
    }
}

