/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source;

import com.github.javaparser.ast.body.TypeDeclaration;
import io.sundr.adapter.api.TypeLookup;
import io.sundr.adapter.source.Project;
import io.sundr.adapter.source.utils.Sources;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Optional;

public class TypeDeclarationLookup
implements TypeLookup<TypeDeclaration> {
    public Optional<TypeDeclaration> forName(String fullyQualifiedName) {
        String resourceName = fullyQualifiedName.replace(".", File.separator) + ".java";
        try {
            Optional<TypeDeclaration> typeDeclaration = Sources.readTypesFromResource(resourceName).stream().findFirst();
            if (typeDeclaration.isPresent()) {
                return typeDeclaration;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Project.getProject().findJavaSourceFile(fullyQualifiedName).flatMap(f -> {
            Optional<TypeDeclaration> optional;
            FileInputStream fis = new FileInputStream(f.toFile());
            try {
                optional = Optional.ofNullable(Sources.readTypeFromStream(fis));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Optional.empty();
                }
            }
            fis.close();
            return optional;
        });
    }
}

