/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source;

import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.VoidRef;
import io.sundr.model.WildcardRef;
import java.util.function.Function;

public class TypeToTypeRef
implements Function<Type, TypeRef> {
    private final Function<ClassOrInterfaceType, TypeRef> classOrInterfaceToTypeRef;

    public TypeToTypeRef(Function<ClassOrInterfaceType, TypeRef> classOrInterfaceToTypeRef) {
        this.classOrInterfaceToTypeRef = classOrInterfaceToTypeRef;
    }

    @Override
    public TypeRef apply(Type type) {
        if (type instanceof VoidType) {
            return new VoidRef();
        }
        if (type instanceof WildcardType) {
            return new WildcardRef();
        }
        if (type instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)type;
            int dimensions = referenceType.getArrayCount();
            TypeRef typeRef = this.apply(referenceType.getType());
            if (dimensions == 0) {
                return typeRef;
            }
            if (typeRef instanceof ClassRef) {
                return ((ClassRefBuilder)new ClassRefBuilder((ClassRef)typeRef).withDimensions(dimensions)).build();
            }
            if (typeRef instanceof PrimitiveRef) {
                return ((PrimitiveRefBuilder)new PrimitiveRefBuilder((PrimitiveRef)typeRef).withDimensions(dimensions)).build();
            }
            if (typeRef instanceof TypeParamRef) {
                return ((TypeParamRefBuilder)new TypeParamRefBuilder((TypeParamRef)typeRef).withDimensions(dimensions)).build();
            }
        } else {
            if (type instanceof PrimitiveType) {
                PrimitiveType primitiveType = (PrimitiveType)type;
                return ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName(primitiveType.getType().name())).build();
            }
            if (type instanceof ClassOrInterfaceType) {
                return this.classOrInterfaceToTypeRef.apply((ClassOrInterfaceType)type);
            }
        }
        throw new IllegalArgumentException("Can't handle type:[" + String.valueOf(type) + "].");
    }
}

