/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source.analysis;

import io.sundr.model.TypeDef;
import io.sundr.model.repo.MethodReference;
import io.sundr.utils.Dependencies;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ImpactAnalysisResult {
    private final Set<Path> affectedFiles;
    private final Set<TypeDef> affectedTypeDefs;
    private final Map<String, String> analysisMetadata;
    private final Dependencies.DependencyTree<MethodReference> dependencyTree;

    public ImpactAnalysisResult(Set<Path> affectedFiles, Set<TypeDef> affectedTypeDefs, Dependencies.DependencyTree<MethodReference> dependencyTree) {
        this.affectedFiles = affectedFiles != null ? Set.copyOf(affectedFiles) : Set.of();
        this.affectedTypeDefs = affectedTypeDefs != null ? Set.copyOf(affectedTypeDefs) : Set.of();
        this.analysisMetadata = Map.of();
        this.dependencyTree = dependencyTree != null ? dependencyTree : Dependencies.newTree();
    }

    public ImpactAnalysisResult(Set<Path> affectedFiles, Set<TypeDef> affectedTypeDefs, Map<String, String> analysisMetadata, Dependencies.DependencyTree<MethodReference> dependencyTree) {
        this.affectedFiles = affectedFiles != null ? Set.copyOf(affectedFiles) : Set.of();
        this.affectedTypeDefs = affectedTypeDefs != null ? Set.copyOf(affectedTypeDefs) : Set.of();
        this.analysisMetadata = analysisMetadata != null ? Map.copyOf(analysisMetadata) : Map.of();
        this.dependencyTree = dependencyTree != null ? dependencyTree : Dependencies.newTree();
    }

    public Set<Path> getAffectedFiles() {
        return this.affectedFiles;
    }

    public Set<TypeDef> getAffectedTypeDefs() {
        return this.affectedTypeDefs;
    }

    public Set<MethodReference> getAffectedMethodReferences() {
        return this.dependencyTree.getAllNodes();
    }

    public boolean hasAnyImpact() {
        return !this.affectedFiles.isEmpty() || !this.affectedTypeDefs.isEmpty() || !this.getAffectedMethodReferences().isEmpty();
    }

    public int getTotalImpactCount() {
        return this.affectedFiles.size() + this.affectedTypeDefs.size() + this.getAffectedMethodReferences().size();
    }

    public Map<String, String> getAnalysisMetadata() {
        return this.analysisMetadata;
    }

    public Dependencies.DependencyTree<MethodReference> getDependencyTree() {
        return this.dependencyTree;
    }

    public Map<String, Set<Path>> getAffectedFilesByDirectory() {
        return this.affectedFiles.stream().collect(Collectors.groupingBy(path -> path.getParent().toString(), Collectors.toSet()));
    }

    public Map<String, Set<TypeDef>> getAffectedTypeDefsByPackage() {
        return this.affectedTypeDefs.stream().collect(Collectors.groupingBy(TypeDef::getPackageName, Collectors.toSet()));
    }

    public String getSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append("Impact Summary: ");
        if (!this.hasAnyImpact()) {
            summary.append("No impact detected");
            return summary.toString();
        }
        summary.append(this.affectedFiles.size()).append(" files, ");
        summary.append(this.affectedTypeDefs.size()).append(" types, ");
        summary.append(this.getAffectedMethodReferences().size()).append(" methods");
        if (!this.analysisMetadata.isEmpty()) {
            String errors;
            summary.append(" [");
            if (this.analysisMetadata.containsKey("analysis_duration_ms")) {
                summary.append("took ").append(this.analysisMetadata.get("analysis_duration_ms")).append("ms");
            }
            if (this.analysisMetadata.containsKey("error_count") && !"0".equals(errors = this.analysisMetadata.get("error_count"))) {
                summary.append(", ").append(errors).append(" errors");
            }
            summary.append("]");
        }
        return summary.toString();
    }

    public String getDependencyTreeVisualization() {
        return this.dependencyTree.render();
    }

    public String toString() {
        Set<MethodReference> affectedMethodReferences;
        StringBuilder sb = new StringBuilder();
        sb.append("Impact Analysis Result:\n");
        if (!this.affectedFiles.isEmpty()) {
            sb.append("  Affected Files (").append(this.affectedFiles.size()).append("):\n");
            this.affectedFiles.forEach(file -> sb.append("    ").append(file).append("\n"));
        }
        if (!this.affectedTypeDefs.isEmpty()) {
            sb.append("  Affected TypeDefs (").append(this.affectedTypeDefs.size()).append("):\n");
            this.affectedTypeDefs.forEach(typeDef -> sb.append("    ").append(typeDef.getFullyQualifiedName()).append("\n"));
        }
        if (!(affectedMethodReferences = this.getAffectedMethodReferences()).isEmpty()) {
            sb.append("  Affected MethodReferences (").append(affectedMethodReferences.size()).append("):\n");
            affectedMethodReferences.forEach(methodRef -> sb.append("    ").append(methodRef).append("\n"));
        }
        if (!this.hasAnyImpact()) {
            sb.append("  No impact detected.\n");
        } else {
            String treeVisualization = this.getDependencyTreeVisualization();
            if (!treeVisualization.trim().isEmpty()) {
                String[] lines;
                sb.append("\n  Dependency Tree:\n");
                for (String line : lines = treeVisualization.split("\n")) {
                    sb.append("    ").append(line).append("\n");
                }
            }
        }
        return sb.toString();
    }
}

