/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.source.change;

import io.sundr.adapter.source.change.Change;
import io.sundr.model.Method;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ChangeSet {
    private final TypeDef oldTypeDef;
    private final TypeDef newTypeDef;
    private final Set<Change<Method>> methodChanges;
    private final Set<Change<Property>> propertyChanges;

    public ChangeSet(TypeDef oldTypeDef, TypeDef newTypeDef, Set<Change<Method>> methodChanges, Set<Change<Property>> propertyChanges) {
        this.oldTypeDef = oldTypeDef;
        this.newTypeDef = newTypeDef;
        this.methodChanges = methodChanges != null ? new HashSet<Change<Method>>(methodChanges) : new HashSet();
        this.propertyChanges = propertyChanges != null ? new HashSet<Change<Property>>(propertyChanges) : new HashSet();
    }

    public TypeDef getOldTypeDef() {
        return this.oldTypeDef;
    }

    public TypeDef getNewTypeDef() {
        return this.newTypeDef;
    }

    public Set<Change<Method>> getMethodChanges() {
        return Collections.unmodifiableSet(this.methodChanges);
    }

    public Set<Change<Property>> getPropertyChanges() {
        return Collections.unmodifiableSet(this.propertyChanges);
    }

    public boolean hasChanges() {
        return !this.methodChanges.isEmpty() || !this.propertyChanges.isEmpty();
    }

    public int getTotalChanges() {
        return this.methodChanges.size() + this.propertyChanges.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChangeSet for ").append(this.newTypeDef != null ? this.newTypeDef.getName() : this.oldTypeDef.getName()).append(":\n");
        if (!this.methodChanges.isEmpty()) {
            sb.append("  Method Changes (").append(this.methodChanges.size()).append("):\n");
            this.methodChanges.forEach(change -> sb.append("    ").append(change).append("\n"));
        }
        if (!this.propertyChanges.isEmpty()) {
            sb.append("  Property Changes (").append(this.propertyChanges.size()).append("):\n");
            this.propertyChanges.forEach(change -> sb.append("    ").append(change).append("\n"));
        }
        if (!this.hasChanges()) {
            sb.append("  No changes detected.\n");
        }
        return sb.toString();
    }
}

