/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal;

import io.sundr.builder.Builder;
import io.sundr.builder.internal.BuilderContext;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.util.Elements;

public class BuilderContextManager {
    private static final AtomicReference<BuilderContext> context = new AtomicReference();

    public static BuilderContext create(Elements elements) {
        BuilderContext ctx = new BuilderContext(elements, Builder.class.getPackage().getName());
        context.set(ctx);
        return ctx;
    }

    public static BuilderContext create(Elements elements, String packageName) {
        BuilderContext ctx = new BuilderContext(elements, packageName);
        if (context.compareAndSet(null, ctx)) {
            return ctx;
        }
        BuilderContext existing = context.get();
        if (packageName.equals(existing.getTargetPackage())) {
            return existing;
        }
        throw new IllegalStateException("Cannot use different target package names in a single project. Used:" + packageName + " but package:" + existing.getTargetPackage() + " already exists.");
    }

    public static synchronized BuilderContext getContext() {
        if (context.get() == null) {
            throw new IllegalStateException("Builder context not available.");
        }
        return context.get();
    }
}

