/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.processor;

import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.ClazzAs;
import io.sundr.builder.internal.processor.AbstractBuilderProcessor;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.utils.ModelUtils;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

@SupportedAnnotationTypes(value={"io.sundr.builder.annotations.Buildable"})
public class BuildableProcessor
extends AbstractBuilderProcessor {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        BuilderContext ctx;
        Buildable buildable;
        Elements elements = this.processingEnv.getElementUtils();
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                buildable = element.getAnnotation(Buildable.class);
                ctx = BuilderContextManager.create(elements, buildable.builderPackage());
                if (!(element instanceof ExecutableElement)) continue;
                ctx.getRepository().register(ModelUtils.getClassElement((Element)element));
            }
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : env.getElementsAnnotatedWith(typeElement)) {
                buildable = element.getAnnotation(Buildable.class);
                if (!(element instanceof ExecutableElement)) continue;
                ctx = BuilderContextManager.create(elements, buildable.builderPackage());
                JavaClazz clazz = ctx.getToClazz().apply(ModelUtils.getClassElement((Element)element));
                this.generateLocalDependenciesIfNeeded();
                try {
                    this.generateFromClazz((JavaClazz)ClazzAs.FLUENT.apply(clazz), "templates/builder/fluent.vm");
                    if (buildable.editableEnabled()) {
                        this.generateFromClazz((JavaClazz)ClazzAs.EDITABLE_BUILDER.apply(clazz), this.selectBuilderTemplate(buildable.validationEnabled()));
                        this.generateFromClazz((JavaClazz)ClazzAs.EDITABLE.apply(clazz), "templates/builder/editable.vm");
                        continue;
                    }
                    this.generateFromClazz((JavaClazz)ClazzAs.BUILDER.apply(clazz), this.selectBuilderTemplate(buildable.validationEnabled()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }
}

