/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.utils;

import io.sundr.builder.Constants;
import io.sundr.builder.internal.BuildableRepository;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.PropertyAs;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.codegen.model.AttributeSupport;
import io.sundr.codegen.model.EditableJavaType;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaPropertyBuilder;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.codegen.utils.StringUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.TypeElement;

public class BuilderUtils {
    public static final String BUILDABLE = "BUILDABLE";

    public static JavaMethod findBuildableConstructor(JavaClazz clazz) {
        for (JavaMethod candidate : clazz.getConstructors()) {
            if (candidate.getArguments().length == 0) continue;
            return candidate;
        }
        return (JavaMethod)clazz.getConstructors().iterator().next();
    }

    public static JavaMethod findGetter(JavaClazz clazz, JavaProperty property) {
        for (JavaMethod method : clazz.getMethods()) {
            if (!BuilderUtils.isApplicableGetterOf(method, property)) continue;
            return method;
        }
        return null;
    }

    private static boolean isApplicableGetterOf(JavaMethod method, JavaProperty property) {
        if (!method.getReturnType().isAssignable(property.getType())) {
            return false;
        }
        if (method.getName().endsWith("get" + property.getNameCapitalized())) {
            return true;
        }
        return method.getName().endsWith("is" + property.getNameCapitalized());
    }

    public static boolean hasDefaultConstructor(JavaClazz item) {
        if (item == null) {
            return false;
        }
        if (item.getConstructors().isEmpty()) {
            return true;
        }
        for (JavaMethod constructor : item.getConstructors()) {
            if (constructor.getArguments().length != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuildable(AttributeSupport item) {
        if (item == null) {
            return false;
        }
        if (item.getAttributes().containsKey(BUILDABLE)) {
            return (Boolean)item.getAttributes().get(BUILDABLE);
        }
        return false;
    }

    public static Set<JavaProperty> getPropertyBuildableAncestors(JavaProperty property) {
        LinkedHashSet<JavaProperty> result = new LinkedHashSet<JavaProperty>();
        JavaType baseType = property.getType();
        if (baseType.isCollection()) {
            JavaType candidate = (JavaType)TypeAs.UNWRAP_COLLECTION_OF.apply(baseType);
            for (JavaType descendant : BuilderUtils.getBuildableDescendants(candidate)) {
                EditableJavaType collectionType = ((JavaTypeBuilder)new JavaTypeBuilder(baseType).withGenericTypes(new JavaType[]{descendant})).build();
                String propertyName = StringUtils.deCaptializeFirst((String)descendant.getSimpleName()) + property.getNameCapitalized();
                result.add((JavaProperty)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder(property).withName(propertyName)).withType((JavaType)collectionType)).addToAttributes("DESCENDANT_OF", (Object)property)).addToAttributes(BUILDABLE, (Object)true)).build());
            }
        } else {
            for (JavaType descendant : BuilderUtils.getBuildableDescendants(baseType)) {
                String propertyName = descendant.getSimpleName() + property.getNameCapitalized();
                result.add((JavaProperty)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder(property).withName(propertyName)).withType(descendant)).addToAttributes("DESCENDANT_OF", (Object)property)).addToAttributes(BUILDABLE, (Object)true)).build());
            }
        }
        return result;
    }

    public static Set<JavaType> getBuildableDescendants(JavaType item) {
        if (item.getFullyQualifiedName().equals(Constants.OBJECT.getFullyQualifiedName())) {
            return new LinkedHashSet<JavaType>();
        }
        LinkedHashSet<JavaType> result = new LinkedHashSet<JavaType>();
        BuilderContext ctx = BuilderContextManager.getContext();
        BuildableRepository repository = ctx.getRepository();
        for (TypeElement element : repository.getBuildables()) {
            JavaType type = (JavaType)ctx.getToType().apply((Object)element.toString());
            if (!BuilderUtils.isDescendant(type, item)) continue;
            result.add(type);
        }
        return result;
    }

    public static boolean hasBuildableDescendants(JavaType item) {
        if (item.getFullyQualifiedName().equals(Constants.OBJECT.getFullyQualifiedName())) {
            return false;
        }
        BuilderContext ctx = BuilderContextManager.getContext();
        BuildableRepository repository = ctx.getRepository();
        for (TypeElement element : repository.getBuildables()) {
            JavaType type = (JavaType)ctx.getToType().apply((Object)element.toString());
            if (!BuilderUtils.isDescendant(type, item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDescendant(JavaType item, JavaType candidate) {
        if (item == null || candidate == null) {
            return false;
        }
        if (item.equals((Object)candidate)) {
            return true;
        }
        if (BuilderUtils.isDescendant(item.getSuperClass(), candidate)) {
            return true;
        }
        for (JavaType interfaceType : item.getInterfaces()) {
            if (!BuilderUtils.isDescendant(interfaceType, candidate)) continue;
            return true;
        }
        return false;
    }

    public static Set<JavaMethod> getInlineableConstructors(JavaProperty property) {
        HashSet<JavaMethod> result = new HashSet<JavaMethod>();
        JavaClazz clazz = (JavaClazz)PropertyAs.CLASS.apply((Object)property);
        for (JavaMethod candidate : clazz.getConstructors()) {
            if (!BuilderUtils.isInlineable(candidate)) continue;
            result.add(candidate);
        }
        return result;
    }

    public static boolean isInlineable(JavaMethod method) {
        if (method.getArguments().length == 0 || method.getArguments().length > 5) {
            return false;
        }
        for (JavaProperty argument : method.getArguments()) {
            if (StringUtils.isNullOrEmpty((String)argument.getType().getPackageName()) || argument.getType().getPackageName().startsWith("java.lang")) continue;
            return false;
        }
        return true;
    }

    public static boolean isMap(JavaType type) {
        return type.equals((Object)Constants.MAP) || type.getInterfaces().contains(Constants.MAP);
    }

    public static boolean isList(JavaType type) {
        return type.equals((Object)Constants.LIST) || type.getInterfaces().contains(Constants.LIST);
    }

    public static boolean isSet(JavaType type) {
        return type.equals((Object)Constants.SET) || type.getInterfaces().contains(Constants.SET);
    }
}

