/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.dsl.internal.element.functions;

import io.sundr.Function;
import io.sundr.codegen.utils.ModelUtils;
import io.sundr.dsl.annotations.EntryPoint;
import io.sundr.dsl.annotations.Terminal;
import io.sundr.dsl.internal.element.functions.ToTransitionAnnotations;
import io.sundr.dsl.internal.element.functions.ToTransitionClassName;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

public class FindTransitions
implements Function<ExecutableElement, Set<ExecutableElement>> {
    private final Elements elements;
    private final Set<AnnotationMirror> whiteList;
    private final ToTransitionAnnotations TO_TRANSITION_ANNOTATIONS;
    private final ToTransitionClassName TO_TRANSITION_CLASSNAME;

    public FindTransitions(Elements elements) {
        this(elements, new LinkedHashSet<AnnotationMirror>());
    }

    public FindTransitions(Elements elements, Set<AnnotationMirror> whiteList) {
        this.elements = elements;
        this.whiteList = whiteList;
        this.TO_TRANSITION_ANNOTATIONS = new ToTransitionAnnotations(elements);
        this.TO_TRANSITION_CLASSNAME = new ToTransitionClassName(elements);
    }

    public Set<ExecutableElement> apply(ExecutableElement element) {
        LinkedHashSet<ExecutableElement> result = new LinkedHashSet<ExecutableElement>();
        TypeElement classElement = ModelUtils.getClassElement((Element)element);
        Set<AnnotationMirror> annotationTransition = this.TO_TRANSITION_ANNOTATIONS.apply(element);
        if (element.getAnnotation(Terminal.class) == null) {
            if (!annotationTransition.isEmpty()) {
                for (AnnotationMirror transition : annotationTransition) {
                    if (!this.whiteList.isEmpty() && !this.whiteList.contains(transition)) continue;
                    for (String className : this.TO_TRANSITION_CLASSNAME.apply(transition)) {
                        result.addAll(this.findMethodsAnnotatedWithClassName(classElement, className));
                    }
                }
            } else {
                result.addAll(ModelUtils.findMethodsAnnotatedWith((TypeElement)classElement, Terminal.class));
            }
        }
        result.removeAll(ModelUtils.findMethodsAnnotatedWith((TypeElement)classElement, EntryPoint.class));
        result.remove(element);
        return result;
    }

    private Set<ExecutableElement> findMethodsAnnotatedWithClassName(TypeElement classElement, String className) {
        LinkedHashSet<ExecutableElement> result = new LinkedHashSet<ExecutableElement>();
        TypeElement annotationType = this.elements.getTypeElement(className);
        for (ExecutableElement methodElement : ElementFilter.methodsIn(classElement.getEnclosedElements())) {
            if (this.getAnnotationMirror(methodElement, annotationType) == null) continue;
            result.add(methodElement);
        }
        return result;
    }

    private AnnotationMirror getAnnotationMirror(ExecutableElement executableElement, TypeElement typeElement) {
        for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().equals(typeElement)) continue;
            return annotationMirror;
        }
        return null;
    }
}

