/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.dsl.internal.utils;

import io.sundr.codegen.model.EditableJavaType;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaClazzBuilder;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.dsl.internal.processor.Node;
import io.sundr.dsl.internal.type.functions.Combine;
import io.sundr.dsl.internal.type.functions.Generics;
import io.sundr.dsl.internal.utils.JavaTypeUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public final class DslUtils {
    private DslUtils() {
    }

    public static JavaClazz createRootInterface(Node<JavaClazz> current, Set<JavaClazz> intermediate) {
        Object rootInterface = null;
        LinkedHashSet<JavaType> interfaces = new LinkedHashSet<JavaType>();
        for (Node<JavaClazz> child : current.getTransitions()) {
            JavaClazz transitionInterface = DslUtils.createTransitionInterface(child, intermediate);
            interfaces.add(transitionInterface.getType());
            intermediate.add(transitionInterface);
            intermediate.add(child.getItem());
        }
        EditableJavaType rootType = ((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(current.getItem().getType()).withInterfaces(interfaces)).withGenericTypes(new JavaType[0])).build();
        return ((JavaClazzBuilder)((JavaClazzBuilder)new JavaClazzBuilder(current.getItem()).withType((JavaType)Generics.UNWRAP.apply(rootType))).withMethods(new LinkedHashSet())).build();
    }

    public static JavaClazz createTransitionInterface(Node<JavaClazz> current, Set<JavaClazz> intermediate) {
        if (current.getTransitions().isEmpty()) {
            return current.getItem();
        }
        if (current.getTransitions().size() == 1) {
            Node<JavaClazz> next = current.getTransitions().iterator().next();
            JavaClazz clazz = current.getItem();
            JavaClazz nextClazz = DslUtils.createTransitionInterface(next, intermediate);
            JavaClazz transition = DslUtils.transition(clazz, nextClazz);
            intermediate.add(nextClazz);
            return transition;
        }
        JavaClazz clazz = current.getItem();
        LinkedHashSet<JavaClazz> toCombine = new LinkedHashSet<JavaClazz>();
        for (Node<JavaClazz> v : current.getTransitions()) {
            toCombine.add(DslUtils.createTransitionInterface(v, intermediate));
        }
        JavaClazz combined = Combine.FUNCTION.apply(toCombine);
        intermediate.addAll(toCombine);
        if (JavaTypeUtils.isCardinalityMultiple(clazz)) {
            JavaClazz selfRef = DslUtils.transition(clazz, combined);
            return DslUtils.transition(clazz, Combine.FUNCTION.apply(Arrays.asList(combined, selfRef)));
        }
        intermediate.add(combined);
        return DslUtils.transition(clazz, combined);
    }

    public static JavaClazz transition(JavaClazz from, JavaClazz to) {
        EditableJavaType transitionInterface = ((JavaTypeBuilder)new JavaTypeBuilder(from.getType()).withGenericTypes(new JavaType[]{to.getType()})).build();
        return ((JavaClazzBuilder)new JavaClazzBuilder(from).withType((JavaType)transitionInterface)).build();
    }
}

