/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.dsl.internal.utils;

import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaType;
import io.sundr.dsl.internal.processor.Node;
import io.sundr.dsl.internal.utils.JavaTypeUtils;
import java.util.LinkedHashSet;
import java.util.Set;

public final class GraphUtils {
    private GraphUtils() {
    }

    public static Set<Node<JavaClazz>> createGraph(Set<JavaClazz> clazzes) {
        LinkedHashSet<Node<JavaClazz>> nodes = new LinkedHashSet<Node<JavaClazz>>();
        for (JavaClazz clazz : clazzes) {
            if (!JavaTypeUtils.isEntryPoint(clazz)) continue;
            nodes.add(GraphUtils.createGraph(clazz, new LinkedHashSet<String>(), clazzes, new LinkedHashSet<JavaType>()));
        }
        return nodes;
    }

    public static Node<JavaClazz> createGraph(JavaClazz root, Set<String> previous, Set<JavaClazz> all, Set<JavaType> visited) {
        Set transitions;
        Boolean usePrevious = JavaTypeUtils.usePreviousTransitions(root);
        LinkedHashSet<JavaClazz> next = new LinkedHashSet<JavaClazz>();
        LinkedHashSet<JavaType> visitedPath = new LinkedHashSet<JavaType>(visited);
        Set set = transitions = usePrevious != false ? previous : (Set)root.getType().getAttributes().get("TRANSITIONS");
        if (!JavaTypeUtils.isTerminal(root)) {
            for (JavaClazz candidate : GraphUtils.exclusion(all, visited)) {
                if (JavaTypeUtils.isEntryPoint(candidate)) continue;
                Set keywords = (Set)candidate.getType().getAttributes().get("KEYWORDS");
                for (String keyword : keywords) {
                    if (!transitions.contains(keyword)) continue;
                    next.add(candidate);
                }
            }
            next.remove(root);
            visitedPath.add(root.getType());
        }
        LinkedHashSet nextVertices = new LinkedHashSet();
        LinkedHashSet<JavaType> levelInterfaces = new LinkedHashSet<JavaType>();
        levelInterfaces.addAll(visitedPath);
        for (JavaClazz c : next) {
            Node<JavaClazz> subGraph = GraphUtils.createGraph(c, usePrevious != false ? previous : transitions, all, levelInterfaces);
            levelInterfaces.add(subGraph.getItem().getType());
            levelInterfaces.addAll(subGraph.getItem().getType().getInterfaces());
            nextVertices.add(subGraph);
        }
        return new Node<JavaClazz>(root, nextVertices);
    }

    private static Set<JavaClazz> exclusion(Set<JavaClazz> one, Set<JavaType> excluded) {
        LinkedHashSet<JavaClazz> result = new LinkedHashSet<JavaClazz>();
        for (JavaClazz item : one) {
            if (excluded.contains(item.getType()) && !JavaTypeUtils.isTerminal(item) && !JavaTypeUtils.isCardinalityMultiple(item)) continue;
            result.add(item);
        }
        return result;
    }
}

