/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.deps.org.apache.velocity.util.introspection;

import io.sundr.deps.org.apache.velocity.runtime.RuntimeServices;
import io.sundr.deps.org.apache.velocity.util.RuntimeServicesAware;
import io.sundr.deps.org.apache.velocity.util.introspection.Info;
import io.sundr.deps.org.apache.velocity.util.introspection.SecureIntrospectorControl;
import io.sundr.deps.org.apache.velocity.util.introspection.SecureIntrospectorImpl;
import io.sundr.deps.org.apache.velocity.util.introspection.UberspectImpl;
import java.util.Iterator;

public class SecureUberspector
extends UberspectImpl
implements RuntimeServicesAware {
    RuntimeServices runtimeServices;

    public void init() {
        String[] badPackages = this.runtimeServices.getConfiguration().getStringArray("introspector.restrict.packages");
        String[] badClasses = this.runtimeServices.getConfiguration().getStringArray("introspector.restrict.classes");
        this.introspector = new SecureIntrospectorImpl(badClasses, badPackages, this.log);
    }

    public Iterator getIterator(Object obj, Info i) throws Exception {
        if (obj != null) {
            SecureIntrospectorControl sic = (SecureIntrospectorControl)((Object)this.introspector);
            if (sic.checkObjectExecutePermission(obj.getClass(), null)) {
                return super.getIterator(obj, i);
            }
            this.log.warn("Cannot retrieve iterator from " + obj.getClass() + " due to security restrictions.");
        }
        return null;
    }

    public void setRuntimeServices(RuntimeServices rs) {
        this.runtimeServices = rs;
    }
}

