/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.velocity.directives;

import io.sundr.codegen.velocity.DefinitionScope;
import io.sundr.model.Method;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.Node;

public class MethodDirective
extends Directive {
    public String getName() {
        return "method";
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        String block = "";
        Method method = null;
        Boolean isInterface = false;
        int level = 1;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) == null) continue;
            if (!(node.jjtGetChild(i) instanceof ASTBlock)) {
                if (i == 0) {
                    method = (Method)node.jjtGetChild(i).value(context);
                    continue;
                }
                if (i == 1) {
                    isInterface = (Boolean)node.jjtGetChild(i).value(context);
                    continue;
                }
                if (i != 2) break;
                level = (Integer)node.jjtGetChild(i).value(context);
                continue;
            }
            StringWriter blockContent = new StringWriter();
            node.jjtGetChild(i).render(context, (Writer)blockContent);
            block = blockContent.toString();
            break;
        }
        boolean hasBody = !method.isAbstract() && (isInterface == false || method.isDefaultMethod());
        this.writeMethod(writer, method, block, hasBody, level);
        return true;
    }

    private void writeMethod(Writer writer, Method method, String block, Boolean hasBody, int level) throws IOException {
        if (method != null) {
            String onetab = MethodDirective.tab(level * 4);
            String twotabs = MethodDirective.tab((level + 1) * 4);
            if (!method.getAnnotations().isEmpty()) {
                writer.append(onetab).append(method.renderAnnotations(onetab));
            }
            if (!method.getComments().isEmpty()) {
                writer.append(onetab).append(method.renderComments(onetab));
            }
            writer.append(onetab).append(method.renderDefinition(DefinitionScope.get()));
            List<String> lines = MethodDirective.getLines(block);
            List indentedLines = lines.stream().map(l -> twotabs + l).collect(Collectors.toList());
            if (hasBody.booleanValue()) {
                writer.append(" {").append(System.lineSeparator());
                for (String line : indentedLines) {
                    writer.append(line).append(System.lineSeparator());
                }
                writer.append(onetab).append("}").append(System.lineSeparator());
            } else {
                writer.append(";");
            }
        }
    }

    private static List<String> getLines(String block) {
        List<String> lines = Arrays.stream(block.split("\r|\n")).collect(Collectors.toList());
        return lines;
    }

    private static int getIndentationLevel(List<String> lines) {
        TreeSet sizes = new TreeSet(lines.stream().map(MethodDirective::level).sorted().collect(Collectors.toSet()));
        int min = (Integer)sizes.first();
        int max = (Integer)sizes.last();
        if (Math.abs(max - min) % 4 == 0) {
            return 4;
        }
        return 2;
    }

    private static int getIndentationBase(List<String> lines) {
        TreeSet sizes = new TreeSet(lines.stream().map(String::length).sorted().collect(Collectors.toSet()));
        int min = (Integer)sizes.first();
        return min;
    }

    private static int level(String line) {
        int level = 0;
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ' ') {
                ++level;
                continue;
            }
            return level;
        }
        return level;
    }

    private static String tab(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

