/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.directives;

import io.sundr.Function;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaKind;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.utils.StringUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.ASTBlock;
import org.apache.velocity.runtime.parser.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDirective
extends Directive {
    private static final JavaType OBJECT_TYPE = new JavaType(JavaKind.CLASS, "java.lang", "Object", false, false, true, null, null, null, new JavaType[0], Collections.<String, Object>emptyMap());

    public String getName() {
        return "class";
    }

    public int getType() {
        return 1;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        String block = "";
        JavaClazz clazz = null;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i) == null) continue;
            if (!(node.jjtGetChild(i) instanceof ASTBlock)) {
                if (i != 0) break;
                clazz = (JavaClazz)node.jjtGetChild(i).value(context);
                continue;
            }
            StringWriter blockContent = new StringWriter();
            node.jjtGetChild(i).render(context, (Writer)blockContent);
            block = blockContent.toString();
            break;
        }
        this.writeClazz(writer, clazz, block);
        return true;
    }

    private void writeClazz(Writer writer, JavaClazz clazz, String block) throws IOException {
        JavaTypeToString toString = new JavaTypeToString(ClassDirective.getEnclosingType(clazz));
        if (clazz != null) {
            JavaType type = clazz.getType();
            JavaKind kind = type.getKind() != null ? type.getKind() : JavaKind.CLASS;
            writer.append("public ").append(kind.name().toLowerCase()).append(" ");
            writer.append(toString.apply(type));
            this.writeExtends(writer, type, toString);
            this.writeImplements(writer, type, toString);
            writer.append("{\n");
            writer.append(block).append("\n}\n");
        }
    }

    private void writeExtends(Writer writer, JavaType type, Function<JavaType, String> toString) throws IOException {
        if (type.getKind() != JavaKind.INTERFACE) {
            if (type.getSuperClass() != null && !OBJECT_TYPE.equals(type.getSuperClass())) {
                writer.append(" extends ").append((CharSequence)toString.apply((Object)type.getSuperClass()));
            }
        } else if (type.getInterfaces().size() > 0) {
            writer.append(" extends ").append(StringUtils.join(type.getInterfaces(), toString, ", "));
        }
    }

    private void writeImplements(Writer writer, JavaType type, Function<JavaType, String> toString) throws IOException {
        if (type.getKind() != JavaKind.INTERFACE && type.getInterfaces().size() > 0) {
            writer.append(" implements ").append(StringUtils.join(type.getInterfaces(), toString, ", "));
        }
    }

    private static JavaType getEnclosingType(JavaClazz clazz) {
        Object obj = clazz.getAttributes().get("MEMBER_OF");
        if (obj instanceof JavaType) {
            return (JavaType)obj;
        }
        return clazz.getType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaTypeToString
    implements Function<JavaType, String> {
        private final JavaType enclosingType;

        JavaTypeToString(JavaType enclosingType) {
            this.enclosingType = enclosingType;
        }

        public String apply(JavaType item) {
            StringBuilder sb = new StringBuilder();
            if (item.getClassName().equals(this.enclosingType.getClassName()) && !item.getFullyQualifiedName().equals(this.enclosingType.getFullyQualifiedName())) {
                sb.append(item.getFullyQualifiedName());
            } else {
                sb.append(item.getClassName());
            }
            if (item.isArray()) {
                sb.append("[]");
            }
            if (item.getKind() == JavaKind.GENERIC && item.getSuperClass() != null) {
                sb.append(" extends " + this.apply(item.getSuperClass()));
            }
            if (item.getGenericTypes() != null && item.getGenericTypes().length > 0) {
                sb.append("<").append(StringUtils.join(item.getGenericTypes(), this, ",")).append(">");
            }
            return sb.toString();
        }
    }
}

