/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.generator;

import io.sundr.codegen.generator.CodeGeneratorContext;
import io.sundr.codegen.generator.GeneratorUtils;
import io.sundr.codegen.utils.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;

public class CodeGenerator<M> {
    private static final String TEMPLATE = "template";
    private static final String MODEL = "model";
    private static final String TEMPLATE_READER_FAILURE = "Failed to read template.";
    private final CodeGeneratorContext context;
    private final Writer writer;
    private final M model;
    private final String templateResource;
    private final URL templateUrl;
    private final Template template;
    private final Set<Class<? extends Directive>> directives;

    public CodeGenerator(CodeGeneratorContext context, M model, Writer writer, URL templateUrl, String templateResource, Set<Class<? extends Directive>> directives) {
        this.context = context != null ? context : new CodeGeneratorContext();
        this.model = model;
        this.writer = writer;
        this.templateResource = templateResource;
        this.templateUrl = templateUrl;
        this.directives = directives;
        StringResourceRepository repo = StringResourceLoader.getRepository();
        try {
            repo.putStringResource(TEMPLATE, templateUrl != null ? StringUtils.loadResource(templateUrl) : StringUtils.loadResource(templateResource));
        }
        catch (Exception e) {
            throw new RuntimeException(TEMPLATE_READER_FAILURE, e);
        }
        for (Class<? extends Directive> directive : directives) {
            context.getVelocityEngine().loadDirective(directive.getCanonicalName());
        }
        this.template = this.context.getVelocityEngine().getTemplate(TEMPLATE);
        this.context.getVelocityContext().put(MODEL, model);
    }

    public CodeGenerator(M model, Writer writer, URL templateUrl, String templateResource, Set<Class<? extends Directive>> directives) {
        this(new CodeGeneratorContext(), model, writer, templateUrl, templateResource, directives);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public M getModel() {
        return this.model;
    }

    public String getTemplateResource() {
        return this.templateResource;
    }

    public URL getTemplateUrl() {
        return this.templateUrl;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Set<Class<? extends Directive>> getDirectives() {
        return this.directives;
    }

    public void generate() throws IOException {
        GeneratorUtils.generate(this.context.getVelocityContext(), this.writer, this.getTemplate());
    }
}

