/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.codegen.model;

import io.sundr.codegen.DefinitionRepository;
import io.sundr.codegen.model.AttributeKey;
import io.sundr.codegen.model.ClassRefBuilder;
import io.sundr.codegen.model.PrimitiveRef;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.model.TypeRef;
import io.sundr.codegen.utils.StringUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassRef
extends TypeRef {
    public static final String UNKWNON = "<unkwnon>";
    public static final String BRACKETS = "[]";
    public static final ClassRef OBJECT = ((ClassRefBuilder)new ClassRefBuilder().withDefinition(TypeDef.OBJECT)).build();
    private final TypeDef definition;
    private final String fullyQualifiedName;
    private final int dimensions;
    private final List<TypeRef> arguments;

    public ClassRef(TypeDef definition, String fullyQualifiedName, int dimensions, List<TypeRef> arguments, Map<AttributeKey, Object> attributes) {
        super(attributes);
        this.definition = definition != null ? definition : new TypeDefBuilder().build();
        this.dimensions = dimensions;
        this.arguments = arguments;
        String string = fullyQualifiedName != null ? fullyQualifiedName : (this.fullyQualifiedName = definition != null ? definition.getFullyQualifiedName() : null);
        if (definition != null) {
            DefinitionRepository.getRepository().registerIfAbsent(definition);
        }
    }

    public TypeDef getDefinition() {
        return DefinitionRepository.getRepository().getDefinition(this.fullyQualifiedName);
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    public List<TypeRef> getArguments() {
        return this.arguments;
    }

    @Override
    public ClassRef withDimensions(int dimensions) {
        return ((ClassRefBuilder)new ClassRefBuilder(this).withDimensions(dimensions)).build();
    }

    @Override
    public boolean isAssignableFrom(TypeRef other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof PrimitiveRef) {
            if (this.getDefinition() == null) {
                return false;
            }
            if (this.getDefinition() != null && !"java.lang".equals(this.getDefinition().getPackageName())) {
                return false;
            }
            return this.getDefinition().getName().toUpperCase().startsWith(((PrimitiveRef)other).getName().toUpperCase());
        }
        if (!(other instanceof ClassRef)) {
            return false;
        }
        if (this == other || this.equals(other)) {
            return true;
        }
        return this.definition.isAssignableFrom(((ClassRef)other).getDefinition());
    }

    public Set<ClassRef> getReferences() {
        LinkedHashSet<ClassRef> refs = new LinkedHashSet<ClassRef>();
        for (TypeRef argument : this.arguments) {
            if (!(argument instanceof ClassRef)) continue;
            refs.addAll(((ClassRef)argument).getReferences());
        }
        refs.add(this);
        return refs;
    }

    private boolean requiresFullyQualifiedName() {
        Map<String, String> referenceMap = DefinitionRepository.getRepository().getReferenceMap();
        if (referenceMap != null && referenceMap.containsKey(this.definition.getName())) {
            String fqn = referenceMap.get(this.definition.getName());
            if (!this.getDefinition().getFullyQualifiedName().equals(fqn)) {
                return true;
            }
        }
        return false;
    }

    public String getName() {
        if (this.requiresFullyQualifiedName()) {
            return this.getDefinition().getFullyQualifiedName();
        }
        return this.getDefinition().getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassRef classRef = (ClassRef)o;
        if (this.dimensions != classRef.dimensions) {
            return false;
        }
        if (this.definition != null ? !this.definition.equals(classRef.definition) : classRef.definition != null) {
            return false;
        }
        return this.arguments != null ? this.arguments.equals(classRef.arguments) : classRef.arguments == null;
    }

    public int hashCode() {
        int result = this.definition != null ? this.definition.hashCode() : 0;
        result = 31 * result + this.dimensions;
        result = 31 * result + (this.arguments != null ? this.arguments.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TypeDef definition = this.getDefinition();
        if (definition == null) {
            sb.append(UNKWNON);
        }
        if (this.requiresFullyQualifiedName()) {
            sb.append(definition.getPackageName()).append(".");
        }
        if (definition.getOuterType() != null) {
            sb.append(definition.getOuterType().getName()).append(".").append(definition.getName());
        } else {
            sb.append(definition.getName());
        }
        if (this.arguments.size() > 0) {
            sb.append("<");
            sb.append(StringUtils.join(this.arguments, ","));
            sb.append(">");
        }
        for (int i = 0; i < this.dimensions; ++i) {
            sb.append(BRACKETS);
        }
        return sb.toString();
    }
}

